/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.metadata.impl;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.plugin.oidc.op.metadata.resolver.RefreshableProviderMetadataResolver;
import net.shibboleth.oidc.metadata.impl.AbstractFileOIDCEntityResolver;
import net.shibboleth.profile.config.OverriddenIssuerProfileConfiguration;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.springframework.core.io.Resource;

public class FilesystemProviderMetadataResolver
extends AbstractFileOIDCEntityResolver<Issuer, OIDCProviderMetadata>
implements RefreshableProviderMetadataResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FilesystemProviderMetadataResolver.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);

    public FilesystemProviderMetadataResolver(@Nonnull Resource metadata) throws IOException {
        super(metadata);
    }

    public FilesystemProviderMetadataResolver(@Nullable Timer backgroundTaskTimer, @Nonnull Resource metadata) throws IOException {
        super(backgroundTaskTimer, metadata);
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    @Nonnull
    public Iterable<OIDCProviderMetadata> resolve(@Nullable ProfileRequestContext profileRequestContext) throws ResolverException {
        RelyingPartyConfiguration rpConfig;
        this.ifNotInitializedThrowUninitializedComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        RelyingPartyContext rpCtx = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        List entities = this.getBackingStore().getOrderedInformation();
        if (rpCtx == null || rpCtx.getConfiguration() == null) {
            this.log.warn("Could not find relying party context, returning all");
            return entities;
        }
        String responderId = null;
        ProfileConfiguration profileConfiguration = rpCtx.getProfileConfig();
        if (profileConfiguration instanceof OverriddenIssuerProfileConfiguration) {
            OverriddenIssuerProfileConfiguration overriddenIssuerProfileConfig = (OverriddenIssuerProfileConfiguration)profileConfiguration;
            responderId = overriddenIssuerProfileConfig.getIssuer(profileRequestContext);
        }
        if (responderId == null && (rpConfig = rpCtx.getConfiguration()) != null) {
            responderId = rpConfig.getIssuer(profileRequestContext);
        }
        String issuer = responderId;
        List<OIDCProviderMetadata> result = entities.stream().filter(e -> e.getIssuer().getValue().equals(issuer)).collect(Collectors.toUnmodifiableList());
        assert (result != null);
        return result;
    }

    @Nullable
    public OIDCProviderMetadata resolveSingle(@Nullable ProfileRequestContext profileRequestContext) throws ResolverException {
        Iterable<OIDCProviderMetadata> iterable = this.resolve(profileRequestContext);
        Iterator<OIDCProviderMetadata> iterator = iterable.iterator();
        if (iterator != null && iterator.hasNext()) {
            return iterator.next();
        }
        this.log.warn("Could not find any clients with the given criteria");
        return null;
    }

    @Nonnull
    protected List<OIDCProviderMetadata> parse(byte[] bytes) throws ParseException {
        OIDCProviderMetadata metadata = OIDCProviderMetadata.parse((JSONObject)JSONObjectUtils.parse((String)new String(bytes)));
        assert (metadata != null);
        return CollectionSupport.listOf((Object)metadata);
    }

    @Nonnull
    protected Issuer getKey(@Nonnull OIDCProviderMetadata value) {
        Issuer issuer = value.getIssuer();
        assert (issuer != null);
        return issuer;
    }
}

