/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.decoding.impl;

import com.nimbusds.oauth2.sdk.Request;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.decoder.servlet.AbstractHttpServletRequestMessageDecoder;
import org.slf4j.Logger;

public abstract class BaseOAuth2RequestDecoder<T extends Request>
extends AbstractHttpServletRequestMessageDecoder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BaseOAuth2RequestDecoder.class);
    private boolean removeIpAddressFromEndpointUri;

    public BaseOAuth2RequestDecoder() {
        this.setProtocolMessageLoggerSubCategory("OAUTH2");
    }

    public synchronized void setRemoveIpAddressFromEndpointUri(boolean flag) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        this.removeIpAddressFromEndpointUri = flag;
    }

    protected void doDecode() throws MessageDecodingException {
        MessageContext messageContext = new MessageContext();
        T requestMessage = this.parseMessage();
        messageContext.setMessage(requestMessage);
        this.setMessageContext(messageContext);
    }

    @Nullable
    protected abstract T parseMessage() throws MessageDecodingException;

    @Nullable
    protected abstract String getMessageToLog(T var1);

    @Nullable
    protected String serializeMessageForLogging(@Nullable Object message) {
        return this.getMessageToLog((Request)message);
    }

    @Nullable
    protected String getEndpointURI(T message) {
        if (this.removeIpAddressFromEndpointUri) {
            HttpServletRequest httpServletRequest = this.getHttpServletRequest();
            return httpServletRequest != null ? httpServletRequest.getRequestURI() : null;
        }
        URI endpointUri = message.getEndpointURI();
        return endpointUri != null ? endpointUri.toString() : null;
    }

    protected void switchIntoCustomResource(@Nonnull HTTPRequest httpRequest) {
        Map params = httpRequest.getQueryParameters();
        String customParameterName = "shibboleth.oidc.op.resource";
        if (params != null && !params.isEmpty() && params.get("resource") != null) {
            List resources = (List)params.get("resource");
            String query = httpRequest.getQuery();
            for (String resource : resources) {
                String encodedResource;
                try {
                    encodedResource = URLEncoder.encode(resource, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    return;
                }
                query = query.replace("resource=" + encodedResource, "shibboleth.oidc.op.resource=" + encodedResource);
                this.log.debug("Replaced resource={} with {}={} : {}", new Object[]{encodedResource, "shibboleth.oidc.op.resource", encodedResource, query});
            }
            httpRequest.setQuery(query);
        } else {
            this.log.trace("No resource parameter(s) found");
        }
    }
}

