/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.decoding.impl;

import com.google.common.base.MoreObjects;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.JakartaServletUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.decoding.impl.RequestUtil;
import net.shibboleth.idp.plugin.oidc.op.oauth2.decoding.impl.BaseOAuth2RequestDecoder;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.slf4j.Logger;

public class OAuth2AuthorizationRequestDecoder
extends BaseOAuth2RequestDecoder<AuthorizationRequest> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(OAuth2AuthorizationRequestDecoder.class);

    @Override
    protected AuthorizationRequest parseMessage() throws MessageDecodingException {
        try {
            HTTPRequest httpReq = JakartaServletUtils.createHTTPRequest((HttpServletRequest)this.getHttpServletRequest());
            this.getProtocolMessageLogger().trace("Inbound request {}", (Object)RequestUtil.toString(httpReq));
            if (httpReq != null) {
                this.switchIntoCustomResource(httpReq);
                return AuthorizationRequest.parse((HTTPRequest)httpReq);
            }
            throw new MessageDecodingException("Could not create HTTPRequest object from the incoming request");
        }
        catch (ParseException | IOException e) {
            this.log.error("Unable to decode inbound request: {}", (Object)e.getMessage());
            throw new MessageDecodingException((Exception)e);
        }
    }

    @Override
    protected String getMessageToLog(@Nullable AuthorizationRequest message) {
        return message == null ? null : MoreObjects.toStringHelper((Object)((Object)this)).omitNullValues().add("clientId", (Object)message.getClientID()).add("codeChallenge", (Object)message.getCodeChallenge()).add("codeChallengeMethod", (Object)message.getCodeChallengeMethod()).add("customParameters", (Object)message.getCustomParameters()).add("endpointURI", (Object)this.getEndpointURI(message)).add("prompt", (Object)message.getPrompt()).add("redirectionURI", (Object)message.getRedirectionURI()).add("requestObject", message.getRequestObject() == null ? null : message.getRequestObject().serialize()).add("requestURI", (Object)message.getRequestURI()).add("resources", (Object)message.getResources()).add("responseMode", (Object)message.getResponseMode()).add("responseType", (Object)message.getResponseType()).add("scope", (Object)message.getScope()).add("state", (Object)message.getState()).toString();
    }
}

