/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.decoding.impl;

import com.google.common.base.MoreObjects;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.TokenIntrospectionRequest;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.JakartaServletUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.decoding.impl.RequestUtil;
import net.shibboleth.idp.plugin.oidc.op.oauth2.decoding.impl.BaseOAuth2RequestDecoder;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.slf4j.Logger;

public class OAuth2IntrospectionRequestDecoder
extends BaseOAuth2RequestDecoder<TokenIntrospectionRequest> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(OAuth2IntrospectionRequestDecoder.class);

    @Override
    protected TokenIntrospectionRequest parseMessage() throws MessageDecodingException {
        try {
            String query;
            HttpServletRequest httpServletRequest = this.getHttpServletRequest();
            String string = query = httpServletRequest != null ? StringSupport.trimOrNull((String)httpServletRequest.getQueryString()) : null;
            if (query != null && query.contains("token=")) {
                this.log.error("The query parameters contain 'token'");
                throw new MessageDecodingException("The query parameters contain 'token'");
            }
            HTTPRequest httpReq = JakartaServletUtils.createHTTPRequest((HttpServletRequest)httpServletRequest);
            this.getProtocolMessageLogger().trace("Inbound request {}", (Object)RequestUtil.toString(httpReq));
            return TokenIntrospectionRequest.parse((HTTPRequest)httpReq);
        }
        catch (ParseException | IOException e) {
            this.log.error("Unable to decode inbound request: {}", (Object)e.getMessage());
            throw new MessageDecodingException((Exception)e);
        }
    }

    @Override
    protected String getMessageToLog(@Nullable TokenIntrospectionRequest message) {
        return message == null ? null : MoreObjects.toStringHelper((Object)((Object)this)).omitNullValues().add("token", (Object)message.getToken()).add("customParameters", (Object)message.getCustomParameters()).add("clientAuthentication", (Object)RequestUtil.getClientAuthenticationLog(message.getClientAuthentication())).add("clientAuthorization", (Object)RequestUtil.getAccessTokenLog(message.getClientAuthorization())).add("endpointURI", (Object)this.getEndpointURI(message)).toString();
    }
}

