/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.decoding.impl;

import com.google.common.base.MoreObjects;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.TokenRevocationRequest;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.JakartaServletUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.decoding.impl.RequestUtil;
import net.shibboleth.idp.plugin.oidc.op.oauth2.decoding.impl.BaseOAuth2RequestDecoder;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.slf4j.Logger;

public class OAuth2RevocationRequestDecoder
extends BaseOAuth2RequestDecoder<TokenRevocationRequest> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(OAuth2RevocationRequestDecoder.class);

    @Override
    protected TokenRevocationRequest parseMessage() throws MessageDecodingException {
        try {
            HTTPRequest httpReq = JakartaServletUtils.createHTTPRequest((HttpServletRequest)this.getHttpServletRequest());
            this.getProtocolMessageLogger().trace("Inbound request {}", (Object)RequestUtil.toString(httpReq));
            return TokenRevocationRequest.parse((HTTPRequest)httpReq);
        }
        catch (ParseException | IOException e) {
            this.log.error("Unable to decode inbound request: {}", (Object)e.getMessage());
            throw new MessageDecodingException((Exception)e);
        }
    }

    @Override
    protected String getMessageToLog(@Nullable TokenRevocationRequest message) {
        return message == null ? null : MoreObjects.toStringHelper((Object)((Object)this)).omitNullValues().add("token", (Object)message.getToken()).add("clientId", (Object)message.getClientID()).add("clientAuthentication", (Object)RequestUtil.getClientAuthenticationLog(message.getClientAuthentication())).add("endpointURI", (Object)this.getEndpointURI(message)).toString();
    }
}

