/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.messaging.impl;

import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.slf4j.Logger;

public class PopulateOIDCMetadataContext
extends AbstractMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateOIDCMetadataContext.class);
    @Nonnull
    private Function<MessageContext, SAMLMetadataContext> samlMetadataContextLookupStrategy;

    public PopulateOIDCMetadataContext() {
        Function smcls = new ChildContextLookup(SAMLMetadataContext.class).compose((Function)new ChildContextLookup(SAMLPeerEntityContext.class));
        assert (smcls != null);
        this.samlMetadataContextLookupStrategy = smcls;
    }

    public void setSAMLMetadataContextLookupStrategy(@Nonnull Function<MessageContext, SAMLMetadataContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.samlMetadataContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLMetadataContext lookup strategy cannot be null");
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) {
        SAMLMetadataContext samlMetadataCtx = this.samlMetadataContextLookupStrategy.apply(messageContext);
        if (samlMetadataCtx == null) {
            this.log.error("Unable to locate SAMLMetadataContext");
            return;
        }
        EntityDescriptor entityDescriptor = samlMetadataCtx.getEntityDescriptor();
        if (entityDescriptor == null) {
            this.log.error("Unable to locate EntityDescriptor");
            return;
        }
        List roleDescriptors = entityDescriptor.getRoleDescriptors(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        for (RoleDescriptor roleDescriptor : roleDescriptors) {
            List clientInformations;
            if (!(roleDescriptor instanceof SPSSODescriptor) || (clientInformations = roleDescriptor.getObjectMetadata().get(OIDCClientInformation.class)).size() <= 0) continue;
            OIDCMetadataContext oidcCtx = new OIDCMetadataContext();
            oidcCtx.setClientInformation((OIDCClientInformation)clientInformations.get(0));
            messageContext.addSubcontext((BaseContext)oidcCtx);
            this.log.debug("{} Client information found and attached", (Object)this.getLogPrefix());
            return;
        }
        this.log.debug("{} No client information found to be attached into OIDC metadata context.", (Object)this.getLogPrefix());
    }
}

