/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl;

import com.nimbusds.jwt.JWT;
import java.time.Duration;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.AccessTokenContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCResponseAction;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.slf4j.Logger;

public class SetAccessTokenToResponseContext
extends AbstractOIDCResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SetAccessTokenToResponseContext.class);
    @Nonnull
    private Function<ProfileRequestContext, AccessTokenContext> accessTokenContextLookupStrategy;
    @Nullable
    private AccessTokenContext tokenCtx;

    public SetAccessTokenToResponseContext() {
        Function atcls = new ChildContextLookup(AccessTokenContext.class).compose(new ChildContextLookup(OIDCAuthenticationResponseContext.class).compose((Function)new OutboundMessageContextLookup()));
        assert (atcls != null);
        this.accessTokenContextLookupStrategy = atcls;
    }

    public void setAccessTokenContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AccessTokenContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.accessTokenContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AccessTokenContext lookup strategy cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.tokenCtx = this.accessTokenContextLookupStrategy.apply(profileRequestContext);
        if (this.tokenCtx == null) {
            this.log.error("{} AccessTokenContext is missing", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        AccessTokenContext nonNullTokenCtx = this.tokenCtx;
        assert (nonNullTokenCtx != null);
        if (nonNullTokenCtx.getJWT() == null && nonNullTokenCtx.getOpaque() == null) {
            this.log.debug("{} Access token is missing", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        if (nonNullTokenCtx.getLifetime() == null) {
            this.log.debug("{} Access token lifetime is missing", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        AccessTokenContext nonNullTokenCtx = this.tokenCtx;
        assert (nonNullTokenCtx != null);
        JWT jwt = nonNullTokenCtx.getJWT();
        String token = jwt != null ? jwt.serialize() : nonNullTokenCtx.getOpaque();
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        Duration lifetime = nonNullTokenCtx.getLifetime();
        assert (lifetime != null);
        oidcResponseContext.setAccessToken(token, lifetime, oidcResponseContext.getScope());
    }
}

