/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.encoding.impl.ResponseUtil;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl.AbstractOAuthAuthorizationResponseAction;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.HttpClientSecuritySupport;
import org.slf4j.Logger;

public class SetRequestObjectToResponseContext
extends AbstractOAuthAuthorizationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SetRequestObjectToResponseContext.class);
    @Nonnull
    private Logger protocolMessageLog = LoggerFactory.getLogger((String)"PROTOCOL_MESSAGE.OAUTH2");
    @NonnullAfterInit
    private HttpClient httpClient;
    @Nullable
    private HttpClientSecurityParameters httpClientSecurityParameters;
    @NonnullAfterInit
    private Predicate<ProfileRequestContext> requestObjectEnforcedPredicate;
    @NonnullAfterInit
    private ObjectMapper objectMapper;

    public void setHttpClient(@Nonnull HttpClient client) {
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HttpClient cannot be null");
    }

    public void setHttpClientSecurityParameters(@Nullable HttpClientSecurityParameters params) {
        this.httpClientSecurityParameters = params;
    }

    public void setRequestObjectEnforcedPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.requestObjectEnforcedPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Request object enforced predicate annot be null");
    }

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        this.checkSetterPreconditions();
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"Object mapper cannot be null");
    }

    @Nonnull
    private HttpClientContext buildHttpContext(@Nonnull ClassicHttpRequest request) {
        HttpClientContext clientContext = HttpClientContext.create();
        assert (clientContext != null);
        HttpClientSecuritySupport.marshalSecurityParameters((HttpClientContext)clientContext, (HttpClientSecurityParameters)this.httpClientSecurityParameters, (boolean)false);
        HttpClientSecuritySupport.addDefaultTLSTrustEngineCriteria((HttpClientContext)clientContext, (HttpRequest)request);
        return clientContext;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.httpClient == null) {
            throw new ComponentInitializationException("Httpclient cannot be null");
        }
        if (this.requestObjectEnforcedPredicate == null) {
            throw new ComponentInitializationException("Request object enforced predicate cannot be null");
        }
        if (this.objectMapper == null) {
            throw new ComponentInitializationException("Object mapper cannot be null");
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (!this.getAuthorizationRequest().specifiesRequestObject()) {
            if (this.requestObjectEnforcedPredicate.test(profileRequestContext)) {
                this.log.warn("{} No request_uri or request by value, even though it's enforced for {}", (Object)this.getLogPrefix(), (Object)this.getAuthorizationRequest().getClientID().getValue());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MissingMandatoryRequestObject");
            } else {
                this.log.debug("{} No request_uri or request by value, nothing to do", (Object)this.getLogPrefix());
            }
            return false;
        }
        if (this.getAuthorizationRequest().getRequestObject() != null && this.getAuthorizationRequest().getRequestURI() != null) {
            this.log.error("{} request_uri and request object cannot be both set", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"RequestObjectAndUri");
            return false;
        }
        return true;
    }

    /*
     * Loose catch block
     */
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        Set allowedURIs;
        OIDCClientMetadata metadata;
        OIDCClientInformation clientInformation;
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        JWT requestObject = this.getAuthorizationRequest().getRequestObject();
        if (requestObject != null) {
            oidcResponseContext.setRequestObject(requestObject);
            this.log.debug("{} Request object {} by value stored to oidc response context", (Object)this.getLogPrefix(), (Object)requestObject.serialize());
            this.doProtocolLog(profileRequestContext, requestObject, "Request object payload contents");
            return;
        }
        boolean authorized = false;
        OIDCMetadataContext metadataContext = this.getMetadataContext();
        if (metadataContext != null && (clientInformation = metadataContext.getClientInformation()) != null && (metadata = clientInformation.getOIDCMetadata()) != null && (allowedURIs = metadata.getRequestObjectURIs()) != null) {
            authorized = allowedURIs.contains(this.getAuthorizationRequest().getRequestURI());
        }
        if (!authorized) {
            this.log.error("{} Unregistered request URI blocked: {}", (Object)this.getLogPrefix(), (Object)this.getAuthorizationRequest().getRequestURI());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRequestUri");
            return;
        }
        HttpGet httpRequest = new HttpGet(this.getAuthorizationRequest().getRequestURI());
        HttpClientContext httpContext = this.buildHttpContext((ClassicHttpRequest)httpRequest);
        try (ClassicHttpResponse response = this.httpClient.executeOpen(null, (ClassicHttpRequest)httpRequest, (HttpContext)httpContext);){
            String scheme = httpRequest.getUri().getScheme();
            assert (scheme != null);
            HttpClientSecuritySupport.checkTLSCredentialEvaluated((HttpClientContext)httpContext, (String)scheme);
            if (response.getCode() == 200) {
                String requestObjectValue = EntityUtils.toString((HttpEntity)response.getEntity());
                try {
                    JWT requestObjectByReference = JWTParser.parse((String)requestObjectValue);
                    assert (requestObjectByReference != null);
                    oidcResponseContext.setRequestObject(requestObjectByReference);
                    this.log.debug("{} Request object {} by reference stored to oidc response context", (Object)this.getLogPrefix(), (Object)JWTParser.parse((String)requestObjectValue).serialize());
                    this.doProtocolLog(profileRequestContext, requestObjectByReference, "Request object (by reference) payload contents");
                    return;
                }
                catch (java.text.ParseException e) {
                    block19: {
                        this.log.error("{} Unable to parse request object from request_uri, {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
                        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRequestUri");
                        if (response == null) break block19;
                        response.close();
                    }
                    return;
                }
            }
            this.log.error("{} Unable to get request object from request_uri, HTTP status {}", (Object)this.getLogPrefix(), (Object)response.getCode());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRequestUri");
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        catch (IOException | URISyntaxException | ParseException e) {
            this.log.error("{} Unable to get request object from request_uri, {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRequestUri");
            return;
        }
    }

    protected void doProtocolLog(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull JWT jwt, @Nonnull String messagePrefix) {
        try {
            assert (this.objectMapper != null);
            this.protocolMessageLog.trace("{}:\n{}", (Object)messagePrefix, (Object)ResponseUtil.getJwtProtocolMessage(jwt, this.objectMapper));
        }
        catch (java.text.ParseException e) {
            this.log.error("{} Could not produce the protocol logger message", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
        }
    }
}

