/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl;

import com.nimbusds.oauth2.sdk.id.ClientID;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultClientIDLookupFunction;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.oidc.metadata.policy.UnregisteredClientPolicy;
import net.shibboleth.oidc.metadata.policy.impl.DefaultMetadataPolicyEnforcer;
import net.shibboleth.oidc.profile.config.navigate.UnregisteredClientPolicyLookupFunction;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidateClientIDAgainstPolicy
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateClientIDAgainstPolicy.class);
    @NonnullAfterInit
    private Function<ProfileRequestContext, Map<String, UnregisteredClientPolicy>> unregisteredClientPolicyLookupStrategy = new UnregisteredClientPolicyLookupFunction();
    @Nonnull
    private Function<MessageContext, ClientID> clientIDLookupStrategy = new DefaultClientIDLookupFunction();
    @Nonnull
    private BiFunction<Object, MetadataPolicy, Pair<Object, Boolean>> unregisteredClientPolicyEnforcer = new DefaultMetadataPolicyEnforcer();
    @Nullable
    private ClientID clientId;
    @Nullable
    private Map<String, UnregisteredClientPolicy> policies;

    public void setClientIDLookupStrategy(@Nonnull Function<MessageContext, ClientID> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.clientIDLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ClientIDLookupStrategy lookup strategy cannot be null");
    }

    public void setUnregisteredClientPolicyLookupStrategy(Function<ProfileRequestContext, Map<String, UnregisteredClientPolicy>> strategy) {
        this.checkSetterPreconditions();
        this.unregisteredClientPolicyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Unregistered client policy lookup strategy cannot be null");
    }

    public void setUnregisteredClientPolicyEnforcer(BiFunction<Object, MetadataPolicy, Pair<Object, Boolean>> enforcer) {
        this.checkSetterPreconditions();
        this.unregisteredClientPolicyEnforcer = (BiFunction)Constraint.isNotNull(enforcer, (String)"Unregistered client policy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        OIDCMetadataContext oidcMetadataContext = (OIDCMetadataContext)profileRequestContext.ensureInboundMessageContext().getSubcontext(OIDCMetadataContext.class);
        if (oidcMetadataContext != null && oidcMetadataContext.getClientInformation() != null) {
            this.log.debug("{} OIDC metadata context is populated: client ID has already been validated against metadata", (Object)this.getLogPrefix());
            return false;
        }
        this.clientId = this.clientIDLookupStrategy.apply(profileRequestContext.getInboundMessageContext());
        if (this.clientId == null) {
            this.log.error("{} Unable to obtain client ID", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.policies = this.unregisteredClientPolicyLookupStrategy.apply(profileRequestContext);
        if (this.policies == null) {
            this.log.warn("{} No policy defined and no OIDC metadata context populated", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AccessDenied");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        Boolean result;
        assert (this.clientId != null);
        String clientIdValue = this.clientId.getValue();
        assert (clientIdValue != null);
        assert (this.policies != null);
        Pair<Object, Boolean> enforcerResult = this.unregisteredClientPolicyEnforcer.apply(clientIdValue, (MetadataPolicy)this.policies.get("client_id"));
        if (enforcerResult != null && (result = (Boolean)enforcerResult.getSecond()) != null && result.booleanValue() && clientIdValue.equals(enforcerResult.getFirst())) {
            this.log.debug("{} The client ID {} is compliant with the policy", (Object)this.getLogPrefix(), (Object)clientIdValue);
            return;
        }
        this.log.warn("{} The client ID {} is not compliant with the policy", (Object)this.getLogPrefix(), (Object)clientIdValue);
        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AccessDenied");
    }
}

