/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl;

import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl.AbstractOAuthAuthorizationResponseAction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultRequestCodeChallengeLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultRequestCodeChallengeMethodLookupFunction;
import net.shibboleth.oidc.profile.config.logic.AllowPKCEPlainPredicate;
import net.shibboleth.oidc.profile.config.logic.ForcePKCEPredicate;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidateCodeChallenge
extends AbstractOAuthAuthorizationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateCodeChallenge.class);
    @Nonnull
    private Predicate<ProfileRequestContext> forcePKCECondition = new ForcePKCEPredicate();
    @Nonnull
    private Predicate<ProfileRequestContext> allowPKCEPlainCondition = new AllowPKCEPlainPredicate();
    @Nonnull
    private Function<ProfileRequestContext, String> codeChallengeLookupStrategy = new DefaultRequestCodeChallengeLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, String> codeChallengeMethodLookupStrategy = new DefaultRequestCodeChallengeMethodLookupFunction();
    private boolean forcePKCE;
    private boolean plainPKCE;
    @Nullable
    private String codeChallenge;
    @Nullable
    private String codeChallengeMethod;

    public void setForcePKCECondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.forcePKCECondition = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    public void setAllowPKCEPlainCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.allowPKCEPlainCondition = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    public void setCodeChallengeLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.codeChallengeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Code challenge lookup strategy cannot be null");
    }

    public void setCodeChallengeMethodLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.codeChallengeMethodLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Code challenge method lookup strategy cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.forcePKCE = this.forcePKCECondition.test(profileRequestContext);
        this.plainPKCE = this.allowPKCEPlainCondition.test(profileRequestContext);
        this.codeChallenge = this.codeChallengeLookupStrategy.apply(profileRequestContext);
        if (StringSupport.trimOrNull((String)this.codeChallenge) == null && !this.forcePKCE) {
            this.log.debug("{} No PKCE code challenge in request, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        this.codeChallengeMethod = this.codeChallengeMethodLookupStrategy.apply(profileRequestContext);
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (StringSupport.trimOrNull((String)this.codeChallenge) == null) {
            this.log.warn("{} No PKCE code challenge presented in authentication request even though required by the profile configuration", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"PKCECodeChallengeRequired");
            return;
        }
        if (StringSupport.trimOrNull((String)this.codeChallengeMethod) == null || "plain".equals(this.codeChallengeMethod)) {
            if (!this.plainPKCE) {
                this.log.warn("{} Plain PKCE code challenge method not allowed", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"PKCEVerifierTransformAlgorithmNotSupported");
                return;
            }
            this.log.debug("{} Plain code challenge exists in the request and is accepted", (Object)this.getLogPrefix());
        } else if ("S256".equals(this.codeChallengeMethod)) {
            this.log.debug("{} S256 code challenge exists in the request", (Object)this.getLogPrefix());
        } else {
            this.log.warn("{} Unknown code challenge method: {}", (Object)this.getLogPrefix(), (Object)this.codeChallengeMethod);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"PKCEVerifierTransformAlgorithmNotSupported");
            return;
        }
    }
}

