/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl;

import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl.AbstractOAuthAuthorizationResponseAction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultRequestRedirectURILookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultValidRedirectUrisLookupFunction;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.oidc.metadata.policy.UnregisteredClientPolicy;
import net.shibboleth.oidc.profile.config.navigate.UnregisteredClientPolicyLookupFunction;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidateRedirectURI
extends AbstractOAuthAuthorizationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateRedirectURI.class);
    @Nonnull
    private Function<ProfileRequestContext, URI> redirectURILookupStrategy = new DefaultRequestRedirectURILookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, Set<URI>> validRedirectURIsLookupStrategy = new DefaultValidRedirectUrisLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, Set<URI>> registeredRedirectURIsLookupStrategy = new DefaultValidRedirectUrisLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, Map<String, UnregisteredClientPolicy>> unregisteredClientPolicyLookupStrategy = new UnregisteredClientPolicyLookupFunction();
    @NonnullAfterInit
    private BiFunction<Object, MetadataPolicy, Pair<Object, Boolean>> unregisteredClientPolicyEnforcer;
    private boolean requireRequestedValue = true;

    public void setRedirectURILookupStrategy(@Nonnull Function<ProfileRequestContext, URI> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.redirectURILookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RedirectURILookupStrategy lookup strategy cannot be null");
    }

    public void setValidRedirectURIsLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<URI>> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.validRedirectURIsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ValidRedirectURIsLookupStrategy lookup strategy cannot be null");
    }

    public void setRegisteredRedirectURIsLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<URI>> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.registeredRedirectURIsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RegisteredRedirectURIsLookupStrategy lookup strategy cannot be null");
    }

    public void setRequireRequestedValue(boolean flag) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.requireRequestedValue = flag;
    }

    public void setUnregisteredClientPolicyLookupStrategy(Function<ProfileRequestContext, Map<String, UnregisteredClientPolicy>> strategy) {
        this.checkSetterPreconditions();
        this.unregisteredClientPolicyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Unregistered client policy lookup strategy cannot be null");
    }

    public void setUnregisteredClientPolicyEnforcer(BiFunction<Object, MetadataPolicy, Pair<Object, Boolean>> enforcer) {
        this.checkSetterPreconditions();
        this.unregisteredClientPolicyEnforcer = (BiFunction)Constraint.isNotNull(enforcer, (String)"Unregistered client policy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.unregisteredClientPolicyEnforcer == null) {
            throw new ConstraintViolationException("Unregistered client policy enforcer cannot be null");
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        URI requestRedirectURI = this.redirectURILookupStrategy.apply(profileRequestContext);
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        if (requestRedirectURI != null && this.getMetadataContext() == null) {
            Boolean enforcerResult;
            Pair<Object, Boolean> result;
            Map<String, UnregisteredClientPolicy> policies = this.unregisteredClientPolicyLookupStrategy.apply(profileRequestContext);
            if (policies != null && policies.containsKey("redirect_uri") && (result = this.unregisteredClientPolicyEnforcer.apply(requestRedirectURI.toString(), (MetadataPolicy)policies.get("redirect_uri"))) != null && (enforcerResult = (Boolean)result.getSecond()) != null && enforcerResult.booleanValue() && requestRedirectURI.toString().equals(result.getFirst())) {
                this.log.debug("{} Redirection URI {} accepted by the policy for unregistered clients", (Object)this.getLogPrefix(), (Object)requestRedirectURI);
                oidcResponseContext.setRedirectURI(requestRedirectURI);
                return;
            }
            this.log.warn("{} Redirection URI {} is not accepted by the policy for unregistered clients", (Object)this.getLogPrefix(), (Object)requestRedirectURI);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRedirectionURI");
            return;
        }
        Set<URI> redirectionURIs = this.validRedirectURIsLookupStrategy.apply(profileRequestContext);
        if (redirectionURIs == null || redirectionURIs.isEmpty()) {
            this.log.warn("{} Client has not registered Redirection URIs. Redirection URI cannot be validated.", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRedirectionURI");
            return;
        }
        if (requestRedirectURI == null) {
            this.handleNullRequestedURI(profileRequestContext, redirectionURIs);
            return;
        }
        if (redirectionURIs.contains(requestRedirectURI)) {
            oidcResponseContext.setRedirectURI(requestRedirectURI);
            this.log.debug("{} Redirection URI validated {}", (Object)this.getLogPrefix(), (Object)requestRedirectURI);
            return;
        }
        Object registered = "";
        for (URI uri : redirectionURIs) {
            registered = (String)registered + (String)(((String)registered).isEmpty() ? uri.toString() : ", " + uri.toString());
        }
        this.log.error("{} Redirection URI {} not matching any of the registered Redirection URIs [{}] ", new Object[]{this.getLogPrefix(), requestRedirectURI.toString(), registered});
        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRedirectionURI");
    }

    protected void handleNullRequestedURI(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull @NotEmpty Set<URI> validRedirectionURIs) {
        if (this.requireRequestedValue) {
            this.log.warn("{} Redirection URI of the request not located for verification", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRedirectionURI");
            return;
        }
        Set<URI> registeredURIs = this.registeredRedirectURIsLookupStrategy.apply(profileRequestContext);
        if (registeredURIs == null || registeredURIs.isEmpty()) {
            this.log.warn("{} Client has not registered Redirection URIs. Redirection URI cannot be validated.", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRedirectionURI");
            return;
        }
        if (registeredURIs.size() == 1 && validRedirectionURIs.size() == 1) {
            URI singleValidUri;
            URI singleRegisteredUri = registeredURIs.iterator().next();
            if (singleRegisteredUri.equals(singleValidUri = validRedirectionURIs.iterator().next())) {
                this.log.debug("{} No requested redirect_uri found, but allowing it due to single trusted value {}", (Object)this.getLogPrefix(), (Object)singleRegisteredUri);
                OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
                assert (oidcResponseContext != null);
                oidcResponseContext.setRedirectURI(singleRegisteredUri);
                return;
            }
            this.log.warn("{} Registered URI '{}' did not match with the valid one '{}'", new Object[]{this.getLogPrefix(), singleRegisteredUri, singleValidUri});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRedirectionURI");
            return;
        }
        this.log.warn("{} Redirection URI of the request missing even though multiple values registered/valid", (Object)this.getLogPrefix());
        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRedirectionURI");
    }
}

