/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.text.ParseException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl.AbstractOAuthAuthorizationResponseAction;
import net.shibboleth.oidc.jwt.claims.ClaimsValidator;
import net.shibboleth.oidc.jwt.claims.JWTValidationException;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidateRequestObject
extends AbstractOAuthAuthorizationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateRequestObject.class);
    @Nullable
    private JWT requestObject;
    @NonnullAfterInit
    private ClaimsValidator signedClaimsValidator;
    @NonnullAfterInit
    private ClaimsValidator plainClaimsValidator;

    public void setSignedClaimsValidator(@Nonnull ClaimsValidator validator) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.signedClaimsValidator = (ClaimsValidator)Constraint.isNotNull((Object)validator, (String)"Signed claims validator cannot be null");
    }

    public void setPlainClaimsValidator(@Nonnull ClaimsValidator validator) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.plainClaimsValidator = (ClaimsValidator)Constraint.isNotNull((Object)validator, (String)"Plain claims validator cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.signedClaimsValidator == null) {
            throw new ComponentInitializationException("ClaimsValidator for signed requests cannot be null");
        }
        if (this.plainClaimsValidator == null) {
            throw new ComponentInitializationException("ClaimsValidator for plain requests cannot be null");
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        this.requestObject = oidcResponseContext.getRequestObject();
        if (this.requestObject == null) {
            this.log.debug("{} No request object, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        JWTClaimsSet claimsSet;
        if (this.requestObject instanceof PlainJWT) {
            JWSAlgorithm requestObjectAlg;
            OIDCClientInformation clientInformation;
            if (this.getMetadataContext() == null) {
                this.log.error("{} Request object unsigned, no client metadata", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRequestObject");
                return;
            }
            OIDCMetadataContext metadataContext = this.getMetadataContext();
            if (metadataContext != null && (clientInformation = metadataContext.getClientInformation()) != null && clientInformation.getOIDCMetadata() != null && (requestObjectAlg = clientInformation.getOIDCMetadata().getRequestObjectJWSAlg()) != null && !"none".equals(requestObjectAlg.getName())) {
                this.log.error("{} Request object is not signed, registered alg is {}", (Object)this.getLogPrefix(), (Object)requestObjectAlg.getName());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRequestObject");
                return;
            }
        }
        try {
            assert (this.requestObject != null);
            claimsSet = this.requestObject.getJWTClaimsSet();
            if (claimsSet.getClaims().containsKey("client_id") && !this.getAuthorizationRequest().getClientID().equals((Object)new ClientID((String)claimsSet.getClaim("client_id")))) {
                this.log.error("{} client_id in request object not matching client_id request parameter", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRequestObject");
                return;
            }
            if (claimsSet.getClaims().containsKey("response_type") && !this.getAuthorizationRequest().getResponseType().equals((Object)new ResponseType(((String)claimsSet.getClaim("response_type")).split(" ")))) {
                this.log.error("{} response_type in request object not matching response_type request parameter", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRequestObject");
                return;
            }
        }
        catch (ParseException e) {
            this.log.error("{} Unable to parse request object {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRequestObject");
            return;
        }
        try {
            if (this.requestObject instanceof SignedJWT) {
                this.signedClaimsValidator.validate(claimsSet, profileRequestContext);
            } else {
                this.plainClaimsValidator.validate(claimsSet, profileRequestContext);
            }
        }
        catch (JWTValidationException e) {
            this.log.warn("{} JWT validation failed: {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRequestObject");
            return;
        }
    }
}

