/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl;

import com.nimbusds.oauth2.sdk.ResponseMode;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl.AbstractOAuthAuthorizationResponseAction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultRequestResponseModeLookupFunction;
import net.shibboleth.oidc.profile.config.navigate.ResponseModesLookupFunction;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidateResponseMode
extends AbstractOAuthAuthorizationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateResponseMode.class);
    @Nonnull
    private Function<ProfileRequestContext, ResponseMode> requestedResponseModeLookupStrategy = new DefaultRequestResponseModeLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> validResponseModesLookupStrategy = new ResponseModesLookupFunction();

    public void setRequestedResponseModeLookupStrategy(@Nonnull Function<ProfileRequestContext, ResponseMode> strategy) {
        this.checkSetterPreconditions();
        this.requestedResponseModeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public void setValidResponseModesLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.checkSetterPreconditions();
        this.validResponseModesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ResponseMode responseMode;
        Set<String> validResponseModes = this.validResponseModesLookupStrategy.apply(profileRequestContext);
        if (validResponseModes == null || validResponseModes.isEmpty()) {
            this.log.debug("{} No restrictions for the response mode", (Object)this.getLogPrefix());
            return;
        }
        ResponseMode requestedMode = this.requestedResponseModeLookupStrategy.apply(profileRequestContext);
        if (requestedMode == null) {
            responseMode = this.getAuthorizationRequest().impliedResponseMode();
            this.log.debug("{} No response mode set in the request, using the default: {}", (Object)this.getLogPrefix(), (Object)responseMode);
        } else {
            responseMode = requestedMode;
            this.log.debug("{} Using requested response mode {}", (Object)this.getLogPrefix(), (Object)responseMode);
        }
        if (!validResponseModes.stream().map(string -> new ResponseMode(string)).toList().contains(responseMode)) {
            this.log.warn("{} Response mode {} is not allowed", (Object)this.getLogPrefix(), (Object)responseMode);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidResponseMode");
        }
    }
}

