/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl;

import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl.AbstractOAuthAuthorizationResponseAction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultRequestResponseTypeLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultValidResponseTypesLookupFunction;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.oidc.metadata.policy.UnregisteredClientPolicy;
import net.shibboleth.oidc.metadata.policy.impl.DefaultMetadataPolicyEnforcer;
import net.shibboleth.oidc.profile.config.navigate.UnregisteredClientPolicyLookupFunction;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidateResponseType
extends AbstractOAuthAuthorizationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateResponseType.class);
    @Nonnull
    private Function<ProfileRequestContext, ResponseType> requestedResponseTypeLookupStrategy = new DefaultRequestResponseTypeLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, Set<ResponseType>> validResponseTypesLookupStrategy = new DefaultValidResponseTypesLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, Map<String, UnregisteredClientPolicy>> unregisteredClientPolicyLookupStrategy = new UnregisteredClientPolicyLookupFunction();
    @Nonnull
    private BiFunction<Object, MetadataPolicy, Pair<Object, Boolean>> unregisteredClientPolicyEnforcer = new DefaultMetadataPolicyEnforcer();

    public void setRequestedResponseTypeLookupStrategy(@Nonnull Function<ProfileRequestContext, ResponseType> strategy) {
        this.checkSetterPreconditions();
        this.requestedResponseTypeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public void setValidResponseTypesLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<ResponseType>> strategy) {
        this.checkSetterPreconditions();
        this.validResponseTypesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public void setUnregisteredClientPolicyLookupStrategy(Function<ProfileRequestContext, Map<String, UnregisteredClientPolicy>> strategy) {
        this.checkSetterPreconditions();
        this.unregisteredClientPolicyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Unregistered client policy lookup strategy cannot be null");
    }

    public void setUnregisteredClientPolicyEnforcer(BiFunction<Object, MetadataPolicy, Pair<Object, Boolean>> enforcer) {
        this.checkSetterPreconditions();
        this.unregisteredClientPolicyEnforcer = (BiFunction)Constraint.isNotNull(enforcer, (String)"Unregistered client policy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        Set<ResponseType> validTypes;
        ResponseType requestedType = this.requestedResponseTypeLookupStrategy.apply(profileRequestContext);
        OIDCMetadataContext metadataContext = this.getMetadataContext();
        if (metadataContext != null) {
            Set registeredTypes;
            OIDCClientInformation clientInformation = metadataContext.getClientInformation();
            if (clientInformation != null && clientInformation.getOIDCMetadata() != null && ((registeredTypes = clientInformation.getMetadata().getResponseTypes()) == null || registeredTypes.isEmpty() || !registeredTypes.contains(requestedType))) {
                this.log.warn("{} The response type {} is not registered for this RP", (Object)this.getLogPrefix(), (Object)requestedType);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidResponseType");
                return;
            }
        } else {
            Boolean validationResult;
            Map<String, UnregisteredClientPolicy> policies = this.unregisteredClientPolicyLookupStrategy.apply(profileRequestContext);
            if (policies == null || policies.isEmpty()) {
                this.log.warn("{} No policy was resolved even though the RP was not registered", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
                return;
            }
            Pair<Object, Boolean> enforcerResult = this.unregisteredClientPolicyEnforcer.apply(requestedType == null ? "" : requestedType.toString(), (MetadataPolicy)policies.get("response_type"));
            if (!(enforcerResult == null || (validationResult = (Boolean)enforcerResult.getSecond()) != null && validationResult.booleanValue())) {
                this.log.warn("{} The response type {} is not compliant with the policy", (Object)this.getLogPrefix(), (Object)requestedType);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidResponseType");
                return;
            }
        }
        if ((validTypes = this.validResponseTypesLookupStrategy.apply(profileRequestContext)) == null || validTypes.isEmpty() || !validTypes.contains(requestedType)) {
            this.log.warn("{} The response type {} is not valid for this request", (Object)this.getLogPrefix(), (Object)requestedType);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidResponseType");
        }
    }
}

