/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.ErrorResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.EventContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.CurrentOrPreviousEventLookup;
import org.slf4j.Logger;

public abstract class AbstractBuildErrorResponseFromEvent<T extends ErrorResponse>
extends AbstractProfileAction {
    public static final String DEFAULT_ERROR_CODE = "invalid_request";
    public static final int DEFAULT_HTTP_STATUS_CODE = 400;
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractBuildErrorResponseFromEvent.class);
    @Nonnull
    private Function<ProfileRequestContext, EventContext> eventContextLookupStrategy = new CurrentOrPreviousEventLookup();
    private Map<String, ErrorObject> mappedErrors = new HashMap<String, ErrorObject>();
    private int defaultStatusCode = 400;
    private String defaultCode = "invalid_request";

    public void setDefaultStatusCode(int code) {
        this.defaultStatusCode = code;
    }

    public void setDefaultCode(@Nonnull String code) {
        this.defaultCode = (String)Constraint.isNotNull((Object)code, (String)"Default code cannot be null");
    }

    public void setEventContextLookupStrategy(@Nonnull Function<ProfileRequestContext, EventContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.eventContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EventContext lookup strategy cannot be null");
    }

    public void setMappedErrors(@Nonnull Map<String, ErrorObject> errors) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.mappedErrors = (Map)Constraint.isNotNull(errors, (String)"Mapped errors cannot be null");
    }

    protected abstract T buildErrorResponse(@Nonnull ErrorObject var1, @Nonnull ProfileRequestContext var2);

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (profileRequestContext.getOutboundMessageContext() == null) {
            this.log.debug("{} No outbound message context initialized, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ErrorObject error;
        EventContext eventCtx = this.eventContextLookupStrategy.apply(profileRequestContext);
        if (eventCtx == null || eventCtx.getEvent() == null) {
            this.log.error("{} No event to be included in the response, nothing to do", (Object)this.getLogPrefix());
            return;
        }
        assert (eventCtx != null);
        Object event = eventCtx.getEvent();
        assert (event != null);
        String eventValue = event.toString();
        if (this.mappedErrors.containsKey(eventValue)) {
            this.log.debug("{} Found mapped event for {}", (Object)this.getLogPrefix(), (Object)eventValue);
            error = this.mappedErrors.get(eventValue);
        } else {
            this.log.debug("{} No mapped event found for {}, creating general {}", new Object[]{this.getLogPrefix(), eventValue, this.defaultCode});
            error = new ErrorObject(this.defaultCode, eventValue, this.defaultStatusCode);
        }
        assert (error != null);
        T errorResponse = this.buildErrorResponse(error, profileRequestContext);
        if (errorResponse != null) {
            profileRequestContext.ensureOutboundMessageContext().setMessage(this.buildErrorResponse(error, profileRequestContext));
            this.log.debug("{} ErrorResponse successfully set as the outbound message", (Object)this.getLogPrefix());
        } else {
            this.log.debug("{} Error response not formed", (Object)this.getLogPrefix());
        }
    }
}

