/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.navigate.OIDCClientRegistrationResponseMetadataLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.navigate.OIDCPolicyEnforcedClientRegistrationRequestMetadataLookupFunction;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public abstract class AbstractOIDCClientMetadataPopulationAction
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractOIDCClientMetadataPopulationAction.class);
    @Nonnull
    private Function<ProfileRequestContext, OIDCClientMetadata> oidcInputMetadataLookupStrategy = new OIDCPolicyEnforcedClientRegistrationRequestMetadataLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, OIDCClientMetadata> oidcOutputMetadataLookupStrategy = new OIDCClientRegistrationResponseMetadataLookupFunction();
    @Nullable
    private OIDCClientMetadata inputMetadata;
    @Nullable
    private OIDCClientMetadata outputMetadata;

    public void setOidcInputMetadataLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCClientMetadata> strategy) {
        this.oidcInputMetadataLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"The input OIDCClientMetadata lookup strategy cannot be null");
    }

    public void setOidcOutputMetadataLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCClientMetadata> strategy) {
        this.oidcOutputMetadataLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"The output OIDCClientMetadata lookup strategy cannot be null");
    }

    protected OIDCClientMetadata getInputMetadata() {
        return this.inputMetadata;
    }

    protected OIDCClientMetadata getOutputMetadata() {
        return this.outputMetadata;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.inputMetadata = this.oidcInputMetadataLookupStrategy.apply(profileRequestContext);
        if (this.inputMetadata == null) {
            this.log.debug("{} No input OIDCMetadata associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.outputMetadata = this.oidcOutputMetadataLookupStrategy.apply(profileRequestContext);
        if (this.outputMetadata == null) {
            this.log.debug("{} No output OIDCMetadata associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        return true;
    }
}

