/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCTokenRequestAction;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public abstract class AbstractOIDCTokenResponseAction
extends AbstractOIDCTokenRequestAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AbstractOIDCTokenResponseAction.class);
    @Nullable
    private OIDCAuthenticationResponseContext oidcResponseContext;
    @Nullable
    private OIDCMetadataContext oidcMetadataContext;

    @Nullable
    public OIDCAuthenticationResponseContext getOidcResponseContext() {
        return this.oidcResponseContext;
    }

    @Nullable
    public OIDCMetadataContext getMetadataContext() {
        return this.oidcMetadataContext;
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (profileRequestContext.getOutboundMessageContext() == null) {
            this.log.error("{} No outbound message context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.oidcResponseContext = (OIDCAuthenticationResponseContext)profileRequestContext.ensureOutboundMessageContext().getSubcontext(OIDCAuthenticationResponseContext.class);
        if (this.oidcResponseContext == null) {
            this.log.error("{} No OIDC response context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        if (profileRequestContext.getInboundMessageContext() == null) {
            this.log.error("{} No inbound message context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.oidcMetadataContext = (OIDCMetadataContext)profileRequestContext.ensureInboundMessageContext().getSubcontext(OIDCMetadataContext.class);
        return true;
    }
}

