/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.OIDCResponseTypeValue;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.AttributesMapContainer;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoder;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.idp.attribute.transcoding.TranscoderSupport;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseConsentContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultResponseClaimsSetLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.OIDCAuthenticationResponseContextLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCResponseAction;
import net.shibboleth.oidc.profile.config.navigate.AlwaysIncludedAttributesLookupFunction;
import net.shibboleth.oidc.profile.config.navigate.DeniedUserInfoAttributesLookupFunction;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.service.ServiceableComponent;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class AddAttributesToClaimsSet
extends AbstractOIDCResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AddAttributesToClaimsSet.class);
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, ClaimsSet> responseClaimsSetLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, OIDCAuthenticationResponseConsentContext> consentContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> alwaysIncludedAttributesLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> deniedUserInfoAttributesLookupStrategy;
    @NonnullAfterInit
    private ReloadableService<AttributeTranscoderRegistry> transcoderRegistry;
    private boolean ignoringUnencodableAttributes;
    @Nullable
    private AttributeContext attributeCtx;
    @Nullable
    private ClaimsSet claimsSet;
    private boolean addToIDTokenByDefault;
    @Nullable
    @NonnullElements
    private List<String> reservedClaimNames;
    @Nullable
    @NonnullElements
    private Set<String> alwaysIncludedAttributes;
    @Nullable
    @NonnullElements
    private Set<String> deniedUserInfoAttributes;

    AddAttributesToClaimsSet() {
        Function acls = new ChildContextLookup(AttributeContext.class).compose((Function)new ChildContextLookup(RelyingPartyContext.class));
        assert (acls != null);
        this.attributeContextLookupStrategy = acls;
        this.responseClaimsSetLookupStrategy = new DefaultResponseClaimsSetLookupFunction();
        Function accls = new ChildContextLookup(OIDCAuthenticationResponseConsentContext.class).compose((Function)new OIDCAuthenticationResponseContextLookupFunction());
        assert (accls != null);
        this.consentContextLookupStrategy = accls;
        this.alwaysIncludedAttributesLookupStrategy = new AlwaysIncludedAttributesLookupFunction();
        this.deniedUserInfoAttributesLookupStrategy = new DeniedUserInfoAttributesLookupFunction();
        this.ignoringUnencodableAttributes = true;
    }

    public void setTranscoderRegistry(@Nonnull ReloadableService<AttributeTranscoderRegistry> registry) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.transcoderRegistry = (ReloadableService)Constraint.isNotNull(registry, (String)"AttributeTranscoderRegistry cannot be null");
    }

    public void setIgnoringUnencodableAttributes(boolean flag) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ignoringUnencodableAttributes = flag;
    }

    public void setReservedClaimNames(List<String> claimNames) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.reservedClaimNames = claimNames;
    }

    public void setResponseClaimsSetLookupStrategy(@Nonnull Function<ProfileRequestContext, ClaimsSet> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.responseClaimsSetLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response Claims Set lookup strategy cannot be null");
    }

    public void setAttributeContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext lookup strategy cannot be null");
    }

    public void setOIDCAuthenticationResponseConsentContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCAuthenticationResponseConsentContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.consentContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCAuthenticationResponseConsentContext lookup strategy cannot be null");
    }

    public void setAlwaysIncludedAttributesLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.alwaysIncludedAttributesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Always included attributes lookup strategy cannot be null");
    }

    public void setDeniedUserInfoAttributesLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.deniedUserInfoAttributesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Denied UserInfo attributes lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.transcoderRegistry == null) {
            throw new ComponentInitializationException("AttributeTranscoderRegistry cannot be null");
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.attributeCtx = this.attributeContextLookupStrategy.apply(profileRequestContext);
        if (this.attributeCtx == null) {
            this.log.debug("{} No AttributeSubcontext available, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        this.claimsSet = this.responseClaimsSetLookupStrategy.apply(profileRequestContext);
        if (this.claimsSet == null) {
            this.log.error("{} No claims set to fill", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        if (this.claimsSet instanceof IDTokenClaimsSet) {
            Object msg = profileRequestContext.ensureInboundMessageContext().getMessage();
            if (msg instanceof AuthenticationRequest) {
                ResponseType responseType = ((AuthenticationRequest)msg).getResponseType();
                this.addToIDTokenByDefault = responseType.contains((Object)OIDCResponseTypeValue.ID_TOKEN) && responseType.size() == 1;
            }
            this.alwaysIncludedAttributes = this.alwaysIncludedAttributesLookupStrategy.apply(profileRequestContext);
            if (this.alwaysIncludedAttributes == null) {
                this.alwaysIncludedAttributes = Collections.emptySet();
            }
            this.deniedUserInfoAttributes = Collections.emptySet();
            this.log.debug("{} ID token always including claims: {}", (Object)this.getLogPrefix(), this.alwaysIncludedAttributes);
        } else if (this.claimsSet instanceof UserInfo) {
            this.deniedUserInfoAttributes = this.deniedUserInfoAttributesLookupStrategy.apply(profileRequestContext);
            if (this.deniedUserInfoAttributes == null) {
                this.deniedUserInfoAttributes = Collections.emptySet();
            }
            this.alwaysIncludedAttributes = Collections.emptySet();
            this.log.debug("{} UserInfo denied claims: {}", (Object)this.getLogPrefix(), this.deniedUserInfoAttributes);
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ArrayList<JSONObject> claims = new ArrayList<JSONObject>();
        OIDCAuthenticationResponseConsentContext consentCtx = this.consentContextLookupStrategy.apply(profileRequestContext);
        try (ServiceableComponent component = this.transcoderRegistry.getServiceableComponent();){
            assert (this.attributeCtx != null);
            for (IdPAttribute attribute : this.attributeCtx.getIdPAttributes().values()) {
                if (attribute == null || attribute.getValues().isEmpty()) continue;
                if (consentCtx != null && !consentCtx.getConsentedAttributes().contains((Object)attribute.getId())) {
                    this.log.debug("{} Consentable attribute {} has no consent. Not added to claims set", (Object)this.getLogPrefix(), (Object)attribute.getId());
                    continue;
                }
                this.encodeAttribute((AttributeTranscoderRegistry)component.getComponent(), profileRequestContext, attribute, claims);
            }
        }
        catch (AttributeEncodingException e) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToEncodeAttribute");
            return;
        }
        for (JSONObject claim : claims) {
            for (String name : claim.keySet()) {
                if (this.reservedClaimNames != null && this.reservedClaimNames.contains(name)) {
                    this.log.debug("{} Claim has a reserved name ({}), not added to claims set", (Object)this.getLogPrefix(), (Object)name);
                    continue;
                }
                this.log.debug("{} Adding claim {} with value {}", new Object[]{this.getLogPrefix(), name, claim.get((Object)name)});
                assert (this.claimsSet != null);
                this.claimsSet.setClaim(name, claim.get((Object)name));
            }
        }
        if (this.log.isDebugEnabled()) {
            assert (this.claimsSet != null);
            String claimsSetValue = this.claimsSet.toJSONObject().toJSONString();
            this.log.debug("{} Claims set after mapping attributes to claims: {}", (Object)this.getLogPrefix(), (Object)claimsSetValue);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void encodeAttribute(@Nonnull AttributeTranscoderRegistry registry, @Nonnull ProfileRequestContext profileRequestContext, @Nonnull IdPAttribute attribute, @Nonnull @NonnullElements @Live Collection<JSONObject> results) throws AttributeEncodingException {
        Collection transcodingRules = registry.getTranscodingRules(attribute, JSONObject.class);
        if (transcodingRules.isEmpty()) {
            this.log.debug("{} Attribute {} does not have any transcoding rules, nothing to do", (Object)this.getLogPrefix(), (Object)attribute.getId());
            return;
        }
        Iterator iterator = transcodingRules.iterator();
        while (iterator.hasNext()) {
            TranscodingRule rule = (TranscodingRule)iterator.next();
            try {
                block12: {
                    Set<String> userInfoDenied;
                    Set<String> alwaysIncluded;
                    Set<String> set = alwaysIncluded = this.alwaysIncludedAttributes == null ? CollectionSupport.emptySet() : this.alwaysIncludedAttributes;
                    assert (alwaysIncluded != null);
                    if (this.claimsSet instanceof IDTokenClaimsSet && !this.addToIDTokenByDefault && !alwaysIncluded.contains(attribute.getId())) {
                        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
                        assert (oidcResponseContext != null);
                        AttributesMapContainer container = oidcResponseContext.getMappedIdTokenRequestedClaims();
                        if (container != null && container.get().containsKey((Object)attribute.getId())) {
                            this.log.debug("{} Attribute {} is targeted for ID Token via claims request", (Object)this.getLogPrefix(), (Object)attribute.getId());
                            break block12;
                        } else {
                            this.log.debug("{} Attribute {} not targeted for ID Token", (Object)this.getLogPrefix(), (Object)attribute.getId());
                            continue;
                        }
                    }
                    Set<String> set2 = userInfoDenied = this.deniedUserInfoAttributes == null ? CollectionSupport.emptySet() : this.deniedUserInfoAttributes;
                    assert (userInfoDenied != null);
                    if (this.claimsSet instanceof UserInfo && userInfoDenied.contains(attribute.getId())) {
                        this.log.debug("{} Attribute {} not targeted for Userinfo Token", (Object)this.getLogPrefix(), (Object)attribute.getId());
                        continue;
                    }
                }
                assert (rule != null);
                AttributeTranscoder transcoder = TranscoderSupport.getTranscoder((TranscodingRule)rule);
                JSONObject encodedAttribute = (JSONObject)transcoder.encode(profileRequestContext, attribute, JSONObject.class, rule);
                if (encodedAttribute == null) continue;
                results.add(encodedAttribute);
            }
            catch (AttributeEncodingException e) {
                this.log.warn("{} Unable to encode attribute {}", new Object[]{this.getLogPrefix(), attribute.getId(), e});
                if (!this.ignoringUnencodableAttributes) throw e;
            }
        }
    }
}

