/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.plugin.oidc.op.messaging.impl.OpenIDConfigurationSuccessResponse;
import net.shibboleth.idp.plugin.oidc.op.metadata.resolver.ProviderMetadataResolver;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class FormOutboundDiscoveryResponse
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FormOutboundDiscoveryResponse.class);
    @NonnullAfterInit
    private ProviderMetadataResolver metadataResolver;
    @Nullable
    private OIDCProviderMetadata metadata;

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.metadataResolver == null) {
            throw new ComponentInitializationException("The metadata resolver cannot be null!");
        }
    }

    public void setMetadataResolver(@Nonnull ProviderMetadataResolver resolver) {
        this.metadataResolver = (ProviderMetadataResolver)Constraint.isNotNull((Object)resolver, (String)"The metadata resolver cannot be null!");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        try {
            this.metadata = (OIDCProviderMetadata)this.metadataResolver.resolveSingle((Object)profileRequestContext);
        }
        catch (ResolverException e) {
            this.log.error("{} Could not resolve provider metadata", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            return false;
        }
        if (this.metadata == null) {
            this.log.error("{} Could not resolve provider metadata", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        assert (this.metadata != null);
        JSONObject metadataContents = this.metadata.toJSONObject();
        assert (metadataContents != null);
        profileRequestContext.ensureOutboundMessageContext().setMessage((Object)new OpenIDConfigurationSuccessResponse(metadataContents));
    }
}

