/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.langtag.LangTag;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.net.URI;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultClientIDLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractInitializeOutboundResponseMessageContext;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.saml.profile.context.navigate.messaging.SAMLMetadataContextLookupFunction;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.ext.saml2mdui.DisplayName;
import org.opensaml.saml.ext.saml2mdui.Logo;
import org.opensaml.saml.ext.saml2mdui.PrivacyStatementURL;
import org.opensaml.saml.ext.saml2mdui.UIInfo;
import org.opensaml.saml.ext.saml2mdui.impl.DisplayNameBuilder;
import org.opensaml.saml.ext.saml2mdui.impl.InformationURLBuilder;
import org.opensaml.saml.ext.saml2mdui.impl.LogoBuilder;
import org.opensaml.saml.ext.saml2mdui.impl.PrivacyStatementURLBuilder;
import org.opensaml.saml.ext.saml2mdui.impl.UIInfoBuilder;
import org.opensaml.saml.saml2.metadata.ContactPerson;
import org.opensaml.saml.saml2.metadata.ContactPersonTypeEnumeration;
import org.opensaml.saml.saml2.metadata.EmailAddress;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.impl.ContactPersonBuilder;
import org.opensaml.saml.saml2.metadata.impl.EmailAddressBuilder;
import org.opensaml.saml.saml2.metadata.impl.EntityDescriptorBuilder;
import org.opensaml.saml.saml2.metadata.impl.ExtensionsBuilder;
import org.opensaml.saml.saml2.metadata.impl.SPSSODescriptorBuilder;
import org.slf4j.Logger;

public class InitializeOutboundAuthenticationResponseMessageContext
extends AbstractInitializeOutboundResponseMessageContext {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InitializeOutboundAuthenticationResponseMessageContext.class);
    @Nonnull
    private Function<ProfileRequestContext, OIDCMetadataContext> oidcMetadataCtxLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyCtxLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, SAMLMetadataContext> samlMetadataCtxLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, ClientID> unregisteredClientIdLookupStrategy;
    @Nullable
    private OIDCMetadataContext oidcMetadataCtx;
    @Nullable
    private RelyingPartyContext relyingPartyCtx;
    @Nonnull
    private String defaultLanguage;

    public InitializeOutboundAuthenticationResponseMessageContext() {
        Function omcls = new ChildContextLookup(OIDCMetadataContext.class).compose((Function)new InboundMessageContextLookup());
        assert (omcls != null);
        this.oidcMetadataCtxLookupStrategy = omcls;
        this.relyingPartyCtxLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
        Function smcls = FunctionSupport.compose((Function)new SAMLMetadataContextLookupFunction(), (Function)new InboundMessageContextLookup());
        assert (smcls != null);
        this.samlMetadataCtxLookupStrategy = smcls;
        Function ucils = FunctionSupport.compose((Function)new DefaultClientIDLookupFunction(), (Function)new InboundMessageContextLookup());
        assert (ucils != null);
        this.unregisteredClientIdLookupStrategy = ucils;
        this.defaultLanguage = "en";
    }

    @Nonnull
    public Function<ProfileRequestContext, OIDCMetadataContext> getOIDCMetadataContextLookupStrategy() {
        return this.oidcMetadataCtxLookupStrategy;
    }

    public void setOIDCMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCMetadataContext> strgy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.oidcMetadataCtxLookupStrategy = (Function)Constraint.isNotNull(strgy, (String)"Injected Metadata Strategy cannot be null");
    }

    @Nonnull
    public Function<ProfileRequestContext, RelyingPartyContext> getRelyingPartyContextLookupStrategy() {
        return this.relyingPartyCtxLookupStrategy;
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.relyingPartyCtxLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    @Nonnull
    public Function<ProfileRequestContext, SAMLMetadataContext> getSAMLMetadataContextLookupStrategy() {
        return this.samlMetadataCtxLookupStrategy;
    }

    public void setSAMLMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLMetadataContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.samlMetadataCtxLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLMetadataContext lookup strategy cannot be null");
    }

    public void setUnregisteredClientIdLookupStrategy(@Nonnull Function<ProfileRequestContext, ClientID> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.unregisteredClientIdLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ClientID lookup strategy cannot be null");
    }

    public void setDefaultLanguage(@Nonnull String language) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.defaultLanguage = Constraint.isNotEmpty((String)language, (String)"The default language cannot be empty");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.oidcMetadataCtx = this.oidcMetadataCtxLookupStrategy.apply(profileRequestContext);
        if (this.oidcMetadataCtx == null) {
            this.log.debug("{} No OIDC metadata context", (Object)this.getLogPrefix());
        }
        this.relyingPartyCtx = this.relyingPartyCtxLookupStrategy.apply(profileRequestContext);
        if (this.relyingPartyCtx == null) {
            this.log.error("{} No relying party context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    @Override
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        super.doExecute(profileRequestContext);
        if (this.samlMetadataCtxLookupStrategy.apply(profileRequestContext) != null) {
            this.log.debug("{} SAML metadata context already found", (Object)this.getLogPrefix());
            return;
        }
        SAMLMetadataContext samlContext = new SAMLMetadataContext();
        EntityDescriptor entityDescriptor = new EntityDescriptorBuilder().buildObject();
        SPSSODescriptor spDescriptor = new SPSSODescriptorBuilder().buildObject();
        if (this.oidcMetadataCtx != null) {
            OIDCClientInformation clientInformation = this.oidcMetadataCtx.getClientInformation();
            if (clientInformation != null) {
                entityDescriptor.setEntityID(clientInformation.getID().getValue());
                this.populateEntityDescriptor(entityDescriptor, spDescriptor, clientInformation);
            }
        } else {
            ClientID clientId = this.unregisteredClientIdLookupStrategy.apply(profileRequestContext);
            if (clientId == null) {
                this.log.error("{} No client ID was resolved for the unregistered client", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
                return;
            }
            entityDescriptor.setEntityID(clientId.getValue());
        }
        samlContext.setEntityDescriptor(entityDescriptor);
        samlContext.setRoleDescriptor((RoleDescriptor)spDescriptor);
        assert (this.relyingPartyCtx != null);
        this.relyingPartyCtx.setRelyingPartyIdContextTree((BaseContext)samlContext);
    }

    protected void populateEntityDescriptor(EntityDescriptor entityDescriptor, SPSSODescriptor spDescriptor, @Nonnull OIDCClientInformation clientInformation) {
        PrivacyStatementURL url;
        OIDCClientMetadata oidcMetadata = clientInformation.getOIDCMetadata();
        UIInfo uiInfo = new UIInfoBuilder().buildObject();
        for (Object tag : oidcMetadata.getLogoURIEntries().keySet()) {
            Logo logo = new LogoBuilder().buildObject();
            logo.setXMLLang(tag == null ? this.defaultLanguage : tag.getLanguage());
            URI logoUri = oidcMetadata.getLogoURI((LangTag)tag);
            if (logoUri == null) continue;
            logo.setURI(logoUri.toString());
            uiInfo.getLogos().add(logo);
        }
        for (Object tag : oidcMetadata.getPolicyURIEntries().keySet()) {
            url = new PrivacyStatementURLBuilder().buildObject();
            url.setXMLLang(tag == null ? this.defaultLanguage : tag.getLanguage());
            url.setURI(oidcMetadata.getPolicyURI((LangTag)tag).toString());
            uiInfo.getPrivacyStatementURLs().add(url);
        }
        for (Object tag : oidcMetadata.getTermsOfServiceURIEntries().keySet()) {
            url = new InformationURLBuilder().buildObject();
            url.setXMLLang(tag == null ? this.defaultLanguage : tag.getLanguage());
            url.setURI(oidcMetadata.getTermsOfServiceURI((LangTag)tag).toString());
            uiInfo.getInformationURLs().add(url);
        }
        List emails = oidcMetadata.getEmailContacts();
        if (emails != null) {
            for (String email : emails) {
                ContactPerson contactPerson = new ContactPersonBuilder().buildObject();
                contactPerson.setType(ContactPersonTypeEnumeration.SUPPORT);
                EmailAddress address = new EmailAddressBuilder().buildObject();
                address.setURI((String)(email.startsWith("mailto:") ? email : "mailto:" + email));
                contactPerson.getEmailAddresses().add(address);
                entityDescriptor.getContactPersons().add(contactPerson);
            }
        }
        for (LangTag tag : oidcMetadata.getNameEntries().keySet()) {
            DisplayName displayName = new DisplayNameBuilder().buildObject();
            displayName.setXMLLang(tag == null ? this.defaultLanguage : tag.getLanguage());
            displayName.setValue((String)oidcMetadata.getNameEntries().get(tag));
            uiInfo.getDisplayNames().add(displayName);
        }
        Extensions extensions = new ExtensionsBuilder().buildObject();
        extensions.getUnknownXMLObjects().add(uiInfo);
        spDescriptor.setExtensions(extensions);
    }
}

