/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultClientIDLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultOIDCMetadataContextLookupFunction;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class InitializeRelyingPartyContext
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InitializeRelyingPartyContext.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextCreationStrategy = new ChildContextLookup(RelyingPartyContext.class, true);
    @Nonnull
    private Function<ProfileRequestContext, OIDCMetadataContext> oidcMetadataContextLookupStrategy = new DefaultOIDCMetadataContextLookupFunction();
    @Nonnull
    private Function<MessageContext, ClientID> clientIDLookupStrategy = new DefaultClientIDLookupFunction();
    @Nullable
    private ClientID clientId;
    private boolean inbound = true;

    public void setClientIDLookupStrategy(@Nonnull Function<MessageContext, ClientID> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.clientIDLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ClientIDLookupStrategy lookup strategy cannot be null");
    }

    public void setRelyingPartyContextCreationStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.relyingPartyContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext creation strategy cannot be null");
    }

    public void setOidcMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCMetadataContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.oidcMetadataContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCMetadataContext lookup strategy cannot be null");
    }

    public void setInbound(boolean flag) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.inbound = flag;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.clientId = this.clientIDLookupStrategy.apply(this.inbound ? profileRequestContext.getInboundMessageContext() : profileRequestContext.getOutboundMessageContext());
        if (this.clientId == null) {
            this.log.error("{} Unable to obtain {}", (Object)(this.inbound ? "client ID" : "resource/audience ID"), (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        OIDCClientInformation clientInformation;
        RelyingPartyContext rpContext = this.relyingPartyContextCreationStrategy.apply(profileRequestContext);
        if (rpContext == null) {
            this.log.error("{} Unable to locate or create RelyingPartyContext", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return;
        }
        assert (this.clientId != null);
        String clientIdValue = this.clientId.getValue();
        this.log.debug("Attaching RelyingPartyContext for {}", (Object)clientIdValue);
        rpContext.setRelyingPartyId(clientIdValue);
        OIDCMetadataContext oidcContext = this.oidcMetadataContextLookupStrategy.apply(profileRequestContext);
        if (oidcContext != null && (clientInformation = oidcContext.getClientInformation()) != null) {
            assert (this.clientId != null);
            if (this.clientId.equals((Object)clientInformation.getID())) {
                this.log.debug("{} Setting the rp context verified", (Object)this.getLogPrefix());
                rpContext.setVerified(Boolean.valueOf(true));
            }
        }
    }
}

