/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.encoding.impl.ResponseUtil;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCAuthenticationResponseAction;
import net.shibboleth.oidc.profile.config.navigate.IDTokenManipulationStrategyLookupFunction;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ManipulateClaimsForIDToken
extends AbstractOIDCAuthenticationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ManipulateClaimsForIDToken.class);
    @Nonnull
    private Logger protocolMessageLog = LoggerFactory.getLogger((String)"PROTOCOL_MESSAGE.OIDC");
    @Nonnull
    private Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> idTokenManipulationStrategyLookupStrategy = new IDTokenManipulationStrategyLookupFunction();
    private BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> manipulationStrategy;
    @NonnullAfterInit
    private ObjectMapper objectMapper;
    private IDTokenClaimsSet idToken;

    public void setIDTokenManipulationStrategyLookupStrategy(@Nonnull Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.idTokenManipulationStrategyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"IDToken manipulation strategy lookup strategy cannot be null");
    }

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        this.checkSetterPreconditions();
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"Object mapper cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.objectMapper == null) {
            throw new ComponentInitializationException("Object mapper cannot be null");
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        this.idToken = oidcResponseContext.getIDToken();
        if (this.idToken == null) {
            this.log.error("{} No id token", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.manipulationStrategy = this.idTokenManipulationStrategyLookupStrategy.apply(profileRequestContext);
        if (this.manipulationStrategy == null) {
            this.log.debug("{} No manipulation strategy resolved, nothing to do.", (Object)this.getLogPrefix());
            assert (this.idToken != null);
            this.doProtocolLog(profileRequestContext, this.idToken);
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        IDTokenClaimsSet newIdToken;
        Map<String, Object> result = this.manipulationStrategy.apply(profileRequestContext, (Map<String, Object>)this.idToken.toJSONObject());
        if (result == null) {
            this.log.debug("{} Manipulation strategy retruned null, leaving id_token claims untouched.", (Object)this.getLogPrefix());
            assert (this.idToken != null);
            this.doProtocolLog(profileRequestContext, this.idToken);
            return;
        }
        this.log.debug("{} Applying the manipulated claims into the id_token", (Object)this.getLogPrefix());
        try {
            newIdToken = new IDTokenClaimsSet(JWTClaimsSet.parse(result));
        }
        catch (ParseException | java.text.ParseException e) {
            this.log.error("{} The resulted claims set could not be transformed into id_token", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return;
        }
        this.log.debug("{} Replacing the id_token with the manipulated contents", (Object)this.getLogPrefix());
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        oidcResponseContext.setIDToken(newIdToken);
        this.doProtocolLog(profileRequestContext, newIdToken);
    }

    protected void doProtocolLog(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull IDTokenClaimsSet claimsSet) {
        try {
            assert (this.objectMapper != null);
            this.protocolMessageLog.trace("ID Token payload contents:\n{}", (Object)ResponseUtil.getIdTokenProtocolMessage(claimsSet, this.objectMapper));
        }
        catch (java.text.ParseException e) {
            this.log.error("{} Could not produce the protocol logger message", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
        }
    }
}

