/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.EventContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.CurrentOrPreviousEventLookup;
import org.slf4j.Logger;

public class SetResponseStatusCodeFromEvent
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SetResponseStatusCodeFromEvent.class);
    @Nonnull
    private Function<ProfileRequestContext, EventContext> eventContextLookupStrategy = new CurrentOrPreviousEventLookup();
    @Nonnull
    private Map<String, Integer> mappedErrors = new HashMap<String, Integer>();
    private int defaultCode = 500;

    public void setEventContextLookupStrategy(@Nonnull Function<ProfileRequestContext, EventContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.eventContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EventContext lookup strategy cannot be null");
    }

    public void setDefaultCode(int code) {
        this.defaultCode = code;
    }

    public void setMappedErrors(@Nonnull Map<String, Integer> errors) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.mappedErrors = (Map)Constraint.isNotNull(errors, (String)"Mapped errors cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        EventContext eventCtx = this.eventContextLookupStrategy.apply(profileRequestContext);
        if (eventCtx == null || eventCtx.getEvent() == null) {
            this.log.error("{} No event to be included in the response, nothing to do", (Object)this.getLogPrefix());
            return;
        }
        HttpServletResponse httpServletResponse = this.getHttpServletResponse();
        if (httpServletResponse == null) {
            this.log.error("{} Cannot set response status code as httpServletResponse is not available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        Object event = eventCtx.getEvent();
        assert (event != null);
        String eventValue = event.toString();
        if (this.mappedErrors.containsKey(eventValue)) {
            this.log.debug("{} Found mapped event for {}", (Object)this.getLogPrefix(), (Object)eventValue);
            httpServletResponse.setStatus(this.mappedErrors.get(eventValue).intValue());
        } else {
            this.log.debug("{} No mapping found for {}, default status code {} set", new Object[]{this.getLogPrefix(), eventValue, this.defaultCode});
            httpServletResponse.setStatus(this.defaultCode);
        }
    }
}

