/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseTokenClaimsContext;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.TokenRequestDeliveryClaimsLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.TokenRequestIDTokenDeliveryClaimsLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.TokenRequestUserInfoDeliveryClaimsLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCResponseAction;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

public class SetTokenDeliveryAttributesFromTokenToResponseContext
extends AbstractOIDCResponseAction {
    @Nonnull
    private Function<ProfileRequestContext, ClaimsSet> deliveryClaimsLookupStrategy = new TokenRequestDeliveryClaimsLookupFunction();
    @Nullable
    private Function<ProfileRequestContext, ClaimsSet> idTokenDeliveryClaimsLookupStrategy = new TokenRequestIDTokenDeliveryClaimsLookupFunction();
    @Nullable
    private Function<ProfileRequestContext, ClaimsSet> userinfoDeliveryClaimsLookupStrategy = new TokenRequestUserInfoDeliveryClaimsLookupFunction();

    public void setDeliveryClaimsLookupStrategy(@Nonnull Function<ProfileRequestContext, ClaimsSet> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.deliveryClaimsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"DeliveryClaimsLookupStrategy lookup strategy cannot be null");
    }

    public void setIDTokenDeliveryClaimsLookupStrategy(@Nullable Function<ProfileRequestContext, ClaimsSet> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.idTokenDeliveryClaimsLookupStrategy = strategy;
    }

    public void setUserinfoDeliveryClaimsLookupStrategy(@Nullable Function<ProfileRequestContext, ClaimsSet> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.userinfoDeliveryClaimsLookupStrategy = strategy;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ClaimsSet userInfoClaims;
        OIDCAuthenticationResponseTokenClaimsContext tokenClaimsCtx;
        ClaimsSet idTokenClaims;
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        ClaimsSet claims = this.deliveryClaimsLookupStrategy.apply(profileRequestContext);
        if (claims != null) {
            OIDCAuthenticationResponseTokenClaimsContext tokenClaimsCtx2 = (OIDCAuthenticationResponseTokenClaimsContext)oidcResponseContext.ensureSubcontext(OIDCAuthenticationResponseTokenClaimsContext.class);
            tokenClaimsCtx2.getClaims().putAll(claims);
        }
        if (this.idTokenDeliveryClaimsLookupStrategy != null && (idTokenClaims = this.idTokenDeliveryClaimsLookupStrategy.apply(profileRequestContext)) != null) {
            tokenClaimsCtx = (OIDCAuthenticationResponseTokenClaimsContext)oidcResponseContext.ensureSubcontext(OIDCAuthenticationResponseTokenClaimsContext.class);
            tokenClaimsCtx.getIdtokenClaims().putAll(idTokenClaims);
        }
        if (this.userinfoDeliveryClaimsLookupStrategy != null && (userInfoClaims = this.userinfoDeliveryClaimsLookupStrategy.apply(profileRequestContext)) != null) {
            tokenClaimsCtx = (OIDCAuthenticationResponseTokenClaimsContext)oidcResponseContext.ensureSubcontext(OIDCAuthenticationResponseTokenClaimsContext.class);
            tokenClaimsCtx.getUserinfoClaims().putAll(userInfoClaims);
        }
    }
}

