/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformationResponse;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCClientRegistrationTokenClaimsContext;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultOIDCClientRegistrationTokenClaimsContextLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.token.support.RegistrationClaimsSet;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.oidc.metadata.ClientInformationManager;
import net.shibboleth.oidc.metadata.ClientInformationManagerException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class StoreClientInformation
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StoreClientInformation.class);
    @Nullable
    private ClientInformationManager clientInformationManager;
    @Nullable
    private Function<ProfileRequestContext, Duration> registrationValidityPeriodStrategy;
    @Nonnull
    private Function<ProfileRequestContext, OIDCClientRegistrationTokenClaimsContext> registrationTokenContextLookupStrategy = new DefaultOIDCClientRegistrationTokenClaimsContextLookupFunction();
    @Nullable
    private OIDCClientRegistrationTokenClaimsContext registrationTokenCtx;
    @Nullable
    private OIDCClientInformationResponse response;

    public void setRegistrationValidityPeriodStrategy(@Nullable Function<ProfileRequestContext, Duration> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.registrationValidityPeriodStrategy = strategy;
    }

    @NonnullAfterInit
    public ClientInformationManager getClientInformationManager() {
        return this.clientInformationManager;
    }

    public void setClientInformationManager(@Nonnull ClientInformationManager manager) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.clientInformationManager = (ClientInformationManager)Constraint.isNotNull((Object)manager, (String)"The client information manager cannot be null!");
    }

    public void setRegistrationTokenContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCClientRegistrationTokenClaimsContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.registrationTokenContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCClientRegistrationTokenClaimsContext lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.clientInformationManager == null) {
            throw new ComponentInitializationException("ClientInformationManager cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (profileRequestContext.getOutboundMessageContext() == null) {
            this.log.error("{} Unable to locate outbound message context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        Object message = profileRequestContext.ensureOutboundMessageContext().getMessage();
        if (message == null || !(message instanceof OIDCClientInformationResponse)) {
            this.log.error("{} Unable to locate outbound message", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.registrationTokenCtx = this.registrationTokenContextLookupStrategy.apply(profileRequestContext);
        if (this.registrationTokenCtx != null && this.registrationTokenCtx.getClaimsSet() == null) {
            this.registrationTokenCtx = null;
        }
        this.response = (OIDCClientInformationResponse)message;
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        boolean replace;
        Duration lifetime;
        assert (this.response != null);
        OIDCClientInformation clientInformation = this.response.getOIDCClientInformation();
        if (clientInformation == null) {
            this.log.error("{} Unable to locate client information from the response message", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return;
        }
        Duration duration = lifetime = this.registrationValidityPeriodStrategy != null ? this.registrationValidityPeriodStrategy.apply(profileRequestContext) : null;
        if (this.registrationTokenCtx != null) {
            RegistrationClaimsSet claimsSet = this.registrationTokenCtx.getClaimsSet();
            assert (claimsSet != null);
            replace = claimsSet.isReplacement();
        } else {
            replace = false;
        }
        this.log.debug("{} Storing client information (replace = {})", (Object)this.getLogPrefix(), (Object)replace);
        try {
            if (lifetime != null && lifetime.isZero()) {
                this.log.debug("{} Registration won't expire, lifetime set to 0", (Object)this.getLogPrefix());
                assert (this.clientInformationManager != null);
                this.clientInformationManager.storeClientInformation(clientInformation, null, replace);
            } else {
                if (lifetime == null) {
                    this.log.debug("{} No registration validity period supplied, using default", (Object)this.getLogPrefix());
                    lifetime = Duration.ofHours(24L);
                }
                Instant expiration = Instant.now().plus(lifetime);
                this.log.debug("{} Registration will expire on {}", (Object)this.getLogPrefix(), (Object)expiration);
                assert (this.clientInformationManager != null);
                this.clientInformationManager.storeClientInformation(clientInformation, expiration, replace);
            }
        }
        catch (ClientInformationManagerException e) {
            this.log.error("{} Could not store the client information", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            return;
        }
        this.log.info("{} Client information successfully stored for {}", (Object)this.getLogPrefix(), (Object)clientInformation.getID().getValue());
    }
}

