/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCTokenResponseAction;
import net.shibboleth.idp.plugin.oidc.op.profile.logic.DefaultChainRevocationLifetimeLookupStrategy;
import net.shibboleth.idp.plugin.oidc.op.storage.RevocationCacheContexts;
import net.shibboleth.idp.plugin.oidc.op.token.support.AuthorizeCodeClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.RefreshTokenClaimsSet;
import net.shibboleth.oidc.profile.config.logic.RefreshTokensEnabledPredicate;
import net.shibboleth.oidc.profile.config.navigate.RefreshTokenChainLifetimeLookupFunction;
import net.shibboleth.oidc.profile.config.navigate.RevocationLifetimeLookupFunction;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.security.DataSealer;
import net.shibboleth.shared.security.DataSealerException;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.ReplayCache;
import org.opensaml.storage.RevocationCache;
import org.slf4j.Logger;

public class ValidateGrant
extends AbstractOIDCTokenResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateGrant.class);
    @Nonnull
    private final DataSealer dataSealer;
    @NonnullAfterInit
    private ReplayCache replayCache;
    @NonnullAfterInit
    private RevocationCache revocationCache;
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> refreshTokensEnabledPredicate;
    @Nonnull
    private Function<ProfileRequestContext, Duration> chainRevocationLifetimeLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Duration> refreshTokenChainLifetimeLookupStrategy;
    @Nonnull
    private List<BiFunction<ProfileRequestContext, String, RefreshTokenClaimsSet>> refreshTokenDeserializers;
    @Nullable
    private RelyingPartyContext rpCtx;
    @Nullable
    private Duration refreshTokenChainLifetime;

    public ValidateGrant(@Nonnull @ParameterName(name="sealer") DataSealer sealer) {
        this.dataSealer = (DataSealer)Constraint.isNotNull((Object)sealer, (String)"DataSealer cannot be null");
        this.relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
        this.refreshTokensEnabledPredicate = new RefreshTokensEnabledPredicate();
        this.chainRevocationLifetimeLookupStrategy = new DefaultChainRevocationLifetimeLookupStrategy();
        ((RevocationLifetimeLookupFunction)this.chainRevocationLifetimeLookupStrategy).setUseActiveProfileOnly(false);
        this.refreshTokenChainLifetimeLookupStrategy = new RefreshTokenChainLifetimeLookupFunction();
        this.refreshTokenDeserializers = CollectionSupport.emptyList();
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setRefreshTokensEnabledPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.refreshTokensEnabledPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Refresh tokens enabled predicate cannot be null");
    }

    public void setReplayCache(@Nonnull ReplayCache cache) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.replayCache = (ReplayCache)Constraint.isNotNull((Object)cache, (String)"ReplayCache cannot be null");
    }

    public void setRevocationCache(@Nonnull RevocationCache cache) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.revocationCache = (RevocationCache)Constraint.isNotNull((Object)cache, (String)"RevocationCache cannot be null");
    }

    public void setChainRevocationLifetimeLookupStrategy(@Nullable Function<ProfileRequestContext, Duration> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.chainRevocationLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public void setRefreshTokenChainLifetimeLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.refreshTokenChainLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Refresh token chain lifetime lookup strategy cannot be null");
    }

    public void setRefreshTokenDeserializers(@Nonnull List<BiFunction<ProfileRequestContext, String, RefreshTokenClaimsSet>> deserializers) {
        this.checkSetterPreconditions();
        this.refreshTokenDeserializers = (List)Constraint.isNotNull(deserializers, (String)"List of refresh token deserializers cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.replayCache == null || this.revocationCache == null) {
            throw new ComponentInitializationException("ReplayCache and RevocationCache cannot be null");
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.rpCtx = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (this.rpCtx == null) {
            this.log.error("{} No relying party context associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        this.refreshTokenChainLifetime = this.refreshTokenChainLifetimeLookupStrategy.apply(profileRequestContext);
        if (this.refreshTokenChainLifetime == null) {
            this.log.warn("{} No lifetime supplied for refresh token", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        AuthorizationGrant grant = this.getTokenRequest().getAuthorizationGrant();
        this.log.debug("{} Validating grant type: {}", (Object)this.getLogPrefix(), (Object)grant.getType());
        AuthorizeCodeClaimsSet tokenClaimsSet = null;
        if (GrantType.AUTHORIZATION_CODE.equals((Object)grant.getType())) {
            AuthorizationCodeGrant codeGrant = (AuthorizationCodeGrant)grant;
            if (codeGrant.getAuthorizationCode() != null && codeGrant.getAuthorizationCode().getValue() != null) {
                try {
                    String codeValue = codeGrant.getAuthorizationCode().getValue();
                    assert (codeValue != null);
                    AuthorizeCodeClaimsSet authzCodeClaimsSet = AuthorizeCodeClaimsSet.parse((String)codeValue, (DataSealer)this.dataSealer);
                    assert (authzCodeClaimsSet != null);
                    String jti = authzCodeClaimsSet.getID();
                    if (jti == null) {
                        this.log.warn("{} Invalid contents in the authz code grant: no JTI", (Object)this.getLogPrefix());
                        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
                        return;
                    }
                    this.log.debug("{} Authz code unwrapped {}", (Object)this.getLogPrefix(), (Object)authzCodeClaimsSet.serialize());
                    String cacheContext = ((Object)((Object)this)).getClass().getName();
                    assert (cacheContext != null);
                    if (!this.replayCache.check(cacheContext, jti, authzCodeClaimsSet.getExp())) {
                        this.log.error("{} Replay detected of authz code {}", (Object)this.getLogPrefix(), (Object)jti);
                        if (!this.revokeChain(jti, this.chainRevocationLifetimeLookupStrategy.apply(profileRequestContext))) {
                            this.log.warn("{} Fatal error, unable to save replayed code to revocation cache", (Object)this.getLogPrefix());
                        }
                        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
                        return;
                    }
                    tokenClaimsSet = authzCodeClaimsSet;
                }
                catch (ParseException | DataSealerException e) {
                    this.log.warn("{} Unwrapping authz code failed: {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
                    return;
                }
            }
        } else if (GrantType.REFRESH_TOKEN.equals((Object)grant.getType())) {
            if (!this.refreshTokensEnabledPredicate.test(profileRequestContext)) {
                this.log.warn("{} Refresh token grant detected, but not enabled", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
                return;
            }
            RefreshTokenGrant refreshTokentokenGrant = (RefreshTokenGrant)grant;
            if (refreshTokentokenGrant.getRefreshToken() != null && refreshTokentokenGrant.getRefreshToken().getValue() != null) {
                String rootJtiToUse;
                String tokenValue = refreshTokentokenGrant.getRefreshToken().getValue();
                assert (tokenValue != null);
                RefreshTokenClaimsSet refreshTokenClaimsSet = this.deserializeRefreshToken(profileRequestContext, tokenValue);
                if (refreshTokenClaimsSet == null) {
                    this.log.warn("{} Unwrapping refresh token failed", (Object)this.getLogPrefix());
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
                    return;
                }
                String rootJti = refreshTokenClaimsSet.getRootTokenIdentifier();
                if (StringSupport.trimOrNull((String)rootJti) == null) {
                    this.log.warn("{} No root token identifier returned, using JWT id for checking revocation status", (Object)this.getLogPrefix());
                    rootJtiToUse = refreshTokenClaimsSet.getID();
                } else {
                    rootJtiToUse = rootJti;
                }
                assert (rootJtiToUse != null);
                String claimsSetJti = refreshTokenClaimsSet.getID();
                assert (claimsSetJti != null);
                if (this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, rootJtiToUse)) {
                    this.log.error("{} Authz code {} and all derived tokens have been revoked", (Object)this.getLogPrefix(), (Object)rootJtiToUse);
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
                    return;
                }
                if (this.revocationCache.isRevoked(RevocationCacheContexts.SINGLE_ACCESS_OR_REFRESH_TOKENS, claimsSetJti)) {
                    this.log.error("{} The refresh token {} has been revoked. Revoking the full chain now.", (Object)this.getLogPrefix(), (Object)refreshTokenClaimsSet.getID());
                    if (!this.revokeChain(rootJtiToUse, this.chainRevocationLifetimeLookupStrategy.apply(profileRequestContext))) {
                        this.log.error("{} Fatal error, unable to store revocation into the revocation cache", (Object)this.getLogPrefix());
                        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
                        return;
                    }
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
                    return;
                }
                Instant chainExp = refreshTokenClaimsSet.getChainExp();
                if (chainExp != null && chainExp.isBefore(Instant.now())) {
                    this.log.warn("{} Refresh token chain has expired on {}", (Object)this.getLogPrefix(), (Object)refreshTokenClaimsSet.getChainExp());
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
                    return;
                }
                tokenClaimsSet = refreshTokenClaimsSet;
                Instant authnTime = tokenClaimsSet.getAuthenticationTime();
                assert (authnTime != null);
                if (Instant.now().isAfter(authnTime.plus(this.refreshTokenChainLifetime))) {
                    this.log.warn("{} Refresh token chain is expired, the authentication instant was {}", (Object)this.getLogPrefix(), (Object)tokenClaimsSet.getAuthenticationTime());
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
                    return;
                }
            }
        } else if (GrantType.CLIENT_CREDENTIALS.equals((Object)grant.getType())) {
            return;
        }
        if (tokenClaimsSet == null) {
            this.log.warn("{} Grant type not supported", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
            return;
        }
        if (!tokenClaimsSet.isTimeValid()) {
            this.log.warn("{} Token is expired or not net valid", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
            return;
        }
        ClientID clientId = tokenClaimsSet.getClientID();
        assert (clientId != null);
        assert (this.rpCtx != null);
        String relyingPartyId = this.rpCtx.getRelyingPartyId();
        if (!clientId.getValue().equals(relyingPartyId)) {
            this.log.warn("{} Token issued to client {}, invalid for {}", new Object[]{this.getLogPrefix(), clientId.getValue(), relyingPartyId});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
            return;
        }
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        oidcResponseContext.setAuthorizationGrantClaimsSet(tokenClaimsSet);
    }

    protected RefreshTokenClaimsSet deserializeRefreshToken(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull String refreshToken) {
        try {
            return RefreshTokenClaimsSet.parse((String)refreshToken, (DataSealer)this.dataSealer);
        }
        catch (ParseException | DataSealerException throwable) {
            for (BiFunction<ProfileRequestContext, String, RefreshTokenClaimsSet> deserializer : this.refreshTokenDeserializers) {
                RefreshTokenClaimsSet deserializedSet = deserializer.apply(profileRequestContext, refreshToken);
                if (deserializedSet == null) continue;
                return deserializedSet;
            }
            return null;
        }
    }

    protected boolean revokeChain(@Nonnull String id, @Nullable Duration lifetime) {
        if (lifetime == null) {
            this.log.warn("{} No profile-specific revocation lifetime could be resolved, using default value", (Object)this.getLogPrefix());
            return this.revocationCache.revoke(RevocationCacheContexts.AUTHORIZATION_CODE, id);
        }
        return this.revocationCache.revoke(RevocationCacheContexts.AUTHORIZATION_CODE, id, lifetime);
    }
}

