/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.logic;

import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoder;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.idp.attribute.transcoding.TranscoderSupport;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class AttributeResolutionSubjectLookupFunction
extends AbstractIdentifiableInitializableComponent
implements ContextDataLookupFunction<ProfileRequestContext, String> {
    @Nonnull
    @NotEmpty
    private static final String SUB_CLAIM_NAME = "sub";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AttributeResolutionSubjectLookupFunction.class);
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy;
    @NonnullAfterInit
    private ReloadableService<AttributeTranscoderRegistry> transcoderRegistry;

    AttributeResolutionSubjectLookupFunction() {
        Function acls = new ChildContextLookup(AttributeContext.class).compose((Function)new ChildContextLookup(RelyingPartyContext.class));
        assert (acls != null);
        this.attributeContextLookupStrategy = acls;
    }

    public void setTranscoderRegistry(@Nonnull ReloadableService<AttributeTranscoderRegistry> registry) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.transcoderRegistry = (ReloadableService)Constraint.isNotNull(registry, (String)"AttributeTranscoderRegistry cannot be null");
    }

    public void setAttributeContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.transcoderRegistry == null) {
            throw new ComponentInitializationException("AttributeTranscoderRegistry cannot be null");
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        AttributeContext attributeCtx = this.attributeContextLookupStrategy.apply(input);
        if (attributeCtx == null) {
            this.log.debug("No AttributeSubcontext available, nothing to do");
            return null;
        }
        try (ServiceableComponent component = this.transcoderRegistry.getServiceableComponent();){
            this.log.debug("Searching for 'sub' claim among encodeable attributes");
            for (IdPAttribute attribute : attributeCtx.getIdPAttributes().values()) {
                Collection transcodingRules;
                if (attribute == null || attribute.getValues().isEmpty() || (transcodingRules = ((AttributeTranscoderRegistry)component.getComponent()).getTranscodingRules(attribute, JSONObject.class)).isEmpty()) continue;
                for (TranscodingRule rule : transcodingRules) {
                    try {
                        String sub;
                        if (!SUB_CLAIM_NAME.equals(rule.getOrDefault("oidc.name", String.class, (Object)attribute.getId()))) continue;
                        this.log.debug("Found candidate rule for attribute '{}'", (Object)attribute.getId());
                        AttributeTranscoder transcoder = TranscoderSupport.getTranscoder((TranscodingRule)rule);
                        JSONObject encodedAttribute = (JSONObject)transcoder.encode(input, attribute, JSONObject.class, rule);
                        if (encodedAttribute == null || (sub = encodedAttribute.getAsString(SUB_CLAIM_NAME)) == null) continue;
                        this.log.debug("Attribute '{}' produced usable value for sub claim", (Object)attribute.getId());
                        String string = sub;
                        return string;
                    }
                    catch (AttributeEncodingException e) {
                        this.log.warn("Unable to encode attribute '{}' as OIDC claim", (Object)attribute.getId(), (Object)e);
                    }
                }
            }
        }
        catch (ServiceException e) {
            this.log.error("Attribute transoding service unavailable");
        }
        this.log.warn("Unable to produce a viable 'sub' claim");
        return null;
    }
}

