/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.logic;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.token.support.RefreshTokenClaimsSet;
import net.shibboleth.oidc.jwt.claims.ClaimsValidator;
import net.shibboleth.oidc.jwt.claims.JWTValidationException;
import net.shibboleth.oidc.security.impl.JWTSignatureValidationUtil;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.ResolverException;
import net.shibboleth.shared.security.DataSealer;
import net.shibboleth.shared.security.DataSealerException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.slf4j.Logger;

public class DefaultJwtRefreshTokenDeserializationFunction
extends AbstractInitializableComponent
implements BiFunction<ProfileRequestContext, String, RefreshTokenClaimsSet> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultJwtRefreshTokenDeserializationFunction.class);
    @NonnullAfterInit
    private ClaimsValidator claimsValidator;
    @NonnullAfterInit
    private CredentialResolver credentialResolver;
    @NonnullAfterInit
    private DataSealer dataSealer;
    @NonnullAfterInit
    private BiPredicate<ProfileRequestContext, String> typeHeaderValidationStrategy;

    public void setDataSealer(@Nonnull DataSealer sealer) {
        this.checkSetterPreconditions();
        this.dataSealer = (DataSealer)Constraint.isNotNull((Object)sealer, (String)"Data sealer cannot be null");
    }

    public void setClaimsValidator(@Nonnull ClaimsValidator validator) {
        this.checkSetterPreconditions();
        this.claimsValidator = (ClaimsValidator)Constraint.isNotNull((Object)validator, (String)"Claims validator cannot be null");
    }

    public void setCredentialResolver(@Nullable CredentialResolver resolver) {
        this.checkSetterPreconditions();
        this.credentialResolver = (CredentialResolver)Constraint.isNotNull((Object)resolver, (String)"Credential resolver cannot be null");
    }

    public void setTypeHeaderValidationStrategy(@Nonnull BiPredicate<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.typeHeaderValidationStrategy = (BiPredicate)Constraint.isNotNull(strategy, (String)"Type header validation strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.dataSealer == null) {
            throw new ComponentInitializationException("Data sealer cannot be null");
        }
        if (this.claimsValidator == null) {
            throw new ComponentInitializationException("Claims validator cannot be null");
        }
        if (this.credentialResolver == null) {
            throw new ComponentInitializationException("Credential resolver cannot be null");
        }
        if (this.typeHeaderValidationStrategy == null) {
            throw new ComponentInitializationException("Type header validation strategy cannot be null");
        }
    }

    @Override
    @Nullable
    public RefreshTokenClaimsSet apply(@Nullable ProfileRequestContext profileRequestContext, @Nullable String token) {
        JWTClaimsSet claimsSet;
        SignedJWT signedJWT;
        if (profileRequestContext == null) {
            this.log.error("Profile request context is null");
            return null;
        }
        try {
            signedJWT = SignedJWT.parse((String)token);
            claimsSet = signedJWT.getJWTClaimsSet();
        }
        catch (ParseException e) {
            this.log.debug("Could not parse the JWT out of incoming token {}", (Object)token, (Object)e);
            return null;
        }
        if (claimsSet == null) {
            this.log.warn("Could not find any claims inside the incoming JWT token");
            return null;
        }
        JOSEObjectType typ = signedJWT.getHeader().getType();
        if (!this.typeHeaderValidationStrategy.test(profileRequestContext, typ == null ? null : typ.getType())) {
            this.log.debug("JWT type header {} did not pass validation", (Object)(typ != null ? typ.getType() : "null"));
            return null;
        }
        ArrayList credList = new ArrayList();
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new UsageCriterion(UsageType.SIGNING)});
        try {
            Iterable creds = this.credentialResolver.resolve((Object)criteriaSet);
            creds.forEach(credList::add);
        }
        catch (ResolverException e) {
            this.log.error("Failure resolving signing credentials, can't verify JWT signature", (Throwable)e);
            return null;
        }
        String errorEventId = JWTSignatureValidationUtil.validateSignatureEx(credList, (SignedJWT)signedJWT, (String)"InvalidGrant");
        if (errorEventId != null) {
            this.log.warn("Signature on refresh token ID '{}' invalid", (Object)claimsSet.getJWTID());
            return null;
        }
        try {
            this.claimsValidator.validate(claimsSet, profileRequestContext);
        }
        catch (JWTValidationException e) {
            this.log.warn("JWT refresh token did not pass the claims validation", (Throwable)e);
            return null;
        }
        return this.decryptSealedClaimsSet(claimsSet);
    }

    protected RefreshTokenClaimsSet decryptSealedClaimsSet(@Nonnull JWTClaimsSet claimsSet) {
        try {
            String sealedClaimsSet = claimsSet.getStringClaim("for_op");
            if (sealedClaimsSet == null) {
                this.log.error("Could not find sealed claims set from the JWT claims set");
                return null;
            }
            assert (this.dataSealer != null);
            return RefreshTokenClaimsSet.parse((String)sealedClaimsSet, (DataSealer)this.dataSealer);
        }
        catch (ParseException | DataSealerException e) {
            this.log.warn("Could not decrypt the sealed claims set", e);
            return null;
        }
    }
}

