/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.logic;

import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.openid.connect.sdk.OIDCScopeValue;
import com.nimbusds.openid.connect.sdk.Prompt;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultRequestedPromptLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.ValidatedScopeLookupFunction;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class DefaultRevokeConsentPredicate
extends AbstractInitializableComponent
implements Predicate<ProfileRequestContext> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultRevokeConsentPredicate.class);
    @Nonnull
    private Function<ProfileRequestContext, Scope> scopeLookupStrategy = new ValidatedScopeLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, Prompt> promptLookupStrategy = new DefaultRequestedPromptLookupFunction();
    @Nonnull
    private Predicate<ProfileRequestContext> revokeWithOfflineAccessScopePredicate = PredicateSupport.alwaysTrue();
    @Nonnull
    private Predicate<ProfileRequestContext> revokeWithConsentPromptPredicate = PredicateSupport.alwaysTrue();

    public void setScopeLookupStrategy(@Nonnull Function<ProfileRequestContext, Scope> strategy) {
        this.checkSetterPreconditions();
        this.scopeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ScopeLookupStrategy lookup strategy cannot be null");
    }

    public void setPromptLookupStrategy(@Nonnull Function<ProfileRequestContext, Prompt> strategy) {
        this.checkSetterPreconditions();
        this.promptLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"PromptLookupStrategy lookup strategy cannot be null");
    }

    public void setRevokeWithOfflineAccessScopePredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.checkSetterPreconditions();
        this.revokeWithOfflineAccessScopePredicate = (Predicate)Constraint.isNotNull(predicate, (String)"RevokeWithOfflineAccessScopePredicate cannot be null");
    }

    public void setRevokeWithConsentPromptPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.checkSetterPreconditions();
        this.revokeWithConsentPromptPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"RevokeWithConsentPromptPredicate cannot be null");
    }

    @Override
    public boolean test(@Nullable ProfileRequestContext input) {
        Scope scope = this.scopeLookupStrategy.apply(input);
        if (scope != null && scope.contains((Object)OIDCScopeValue.OFFLINE_ACCESS) && this.revokeWithOfflineAccessScopePredicate.test(input)) {
            this.log.debug("Pre-existing consent to be revoked as offline_access scope is requested");
            return true;
        }
        Prompt prompt = this.promptLookupStrategy.apply(input);
        if (prompt != null && prompt.contains((Object)Prompt.Type.CONSENT) && this.revokeWithConsentPromptPredicate.test(input)) {
            this.log.debug("Pre-existing consent to be revoked as user consent is requested");
            return true;
        }
        return false;
    }
}

