/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.logic;

import com.nimbusds.openid.connect.sdk.SubjectType;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultOIDCMetadataContextLookupFunction;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

public class DefaultSubjectTypeStrategy
implements Function<ProfileRequestContext, SubjectType> {
    @Nonnull
    private Function<ProfileRequestContext, OIDCMetadataContext> oidcMetadataContextLookupStrategy = new DefaultOIDCMetadataContextLookupFunction();

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
    }

    public void setOIDCMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCMetadataContext> strategy) {
        this.oidcMetadataContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCMetadata lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public SubjectType apply(@Nullable ProfileRequestContext input) {
        OIDCClientInformation clientInformation;
        SubjectType type = null;
        OIDCMetadataContext ctx = this.oidcMetadataContextLookupStrategy.apply(input);
        if (ctx != null && (clientInformation = ctx.getClientInformation()) != null && clientInformation.getOIDCMetadata() != null) {
            type = clientInformation.getOIDCMetadata().getSubjectType();
        }
        return type == null ? SubjectType.PUBLIC : type;
    }
}

