/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.session.impl;

import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultClientIDLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultOIDCMetadataContextLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.OIDCAuthenticationResponseContextLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.session.OIDCRPSession;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.slf4j.Logger;

public class OIDCRPSessionCreationStrategy
extends AbstractInitializableComponent
implements Function<ProfileRequestContext, SPSession> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(OIDCRPSessionCreationStrategy.class);
    @Nonnull
    private final Duration sessionLifetime;
    @Nonnull
    private Function<ProfileRequestContext, OIDCMetadataContext> oidcMetadataContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, OIDCAuthenticationResponseContext> oidcResponseContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, ClientID> clientIDLookupStrategy;

    public OIDCRPSessionCreationStrategy(@Nonnull Duration lifetime) {
        this.sessionLifetime = (Duration)Constraint.isNotNull((Object)lifetime, (String)"Lifetime cannot be null");
        this.oidcMetadataContextLookupStrategy = new DefaultOIDCMetadataContextLookupFunction();
        this.oidcResponseContextLookupStrategy = new OIDCAuthenticationResponseContextLookupFunction();
        this.clientIDLookupStrategy = FunctionSupport.compose((Function)new DefaultClientIDLookupFunction(), (Function)new InboundMessageContextLookup());
    }

    public void setOidcMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCMetadataContext> strategy) {
        this.checkSetterPreconditions();
        this.oidcMetadataContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public void setOidcResponseContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCAuthenticationResponseContext> strategy) {
        this.checkSetterPreconditions();
        this.oidcResponseContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public void setClientIDLookupStrategy(@Nonnull Function<ProfileRequestContext, ClientID> strategy) {
        this.checkSetterPreconditions();
        this.clientIDLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public SPSession apply(@Nullable ProfileRequestContext profileRequestContext) {
        String sessionIdentifier;
        String rootTokenIdentifier;
        OIDCAuthenticationResponseContext oidcAuthenticationResponseContext = this.oidcResponseContextLookupStrategy.apply(profileRequestContext);
        if (oidcAuthenticationResponseContext == null) {
            this.log.debug("OIDCAuthenticationResponseContext cannot be null, no OIDCRPSession created");
            return null;
        }
        TokenClaimsSet tokenClaimsSet = oidcAuthenticationResponseContext.getAuthorizationGrantClaimsSet();
        IDTokenClaimsSet idTokenClaimsSet = oidcAuthenticationResponseContext.getIDToken();
        ClientID clientIdentifier = this.clientIDLookupStrategy.apply(profileRequestContext);
        if (clientIdentifier == null || StringSupport.trimOrNull((String)clientIdentifier.getValue()) == null) {
            this.log.debug("ClientID/RelyingPartyId cannot be null, no OIDCRPSession created.");
            return null;
        }
        String clientIdentifierValue = clientIdentifier.getValue();
        assert (clientIdentifierValue != null);
        Instant now = Instant.now();
        assert (now != null);
        String issuer = this.getIssuer(tokenClaimsSet, idTokenClaimsSet);
        if (issuer == null) {
            this.log.debug("Issuer cannot be null, no OIDCRPSession created.");
            return null;
        }
        if (tokenClaimsSet != null) {
            String string = rootTokenIdentifier = tokenClaimsSet.getRootTokenIdentifier() != null ? tokenClaimsSet.getRootTokenIdentifier() : tokenClaimsSet.getID();
            if (rootTokenIdentifier == null) {
                this.log.debug("RootTokenIdentifier (root jti) cannot be null in the authorization grant context");
                return null;
            }
        } else {
            this.log.debug("RootTokenIdentifier won't be set to OIDCRPSession");
            rootTokenIdentifier = null;
        }
        if ((sessionIdentifier = this.getSessionIdentifier(tokenClaimsSet, idTokenClaimsSet)) == null) {
            this.log.debug("SessionIdentifier cannot be null, no OIDCRPSession created.");
            return null;
        }
        String subject = this.getSubject(tokenClaimsSet, idTokenClaimsSet);
        if (subject == null) {
            this.log.debug("Subject cannot be null, no OIDCRPSession created.");
            return null;
        }
        boolean supportsLogoutPropagation = this.isSupportsLogoutPropagation(profileRequestContext);
        Instant expiration = now.plus(this.sessionLifetime);
        assert (expiration != null);
        return new OIDCRPSession.Builder().serviceId(clientIdentifierValue).creationInstant(now).expirationInstant(expiration).issuer(issuer).rootTokenIdentifier(rootTokenIdentifier).sessionIdentifier(sessionIdentifier).subject(subject).supportLogoutPropagation(supportsLogoutPropagation).build();
    }

    @Nullable
    protected String getSessionIdentifier(@Nullable TokenClaimsSet tokenClaimsSet, @Nullable IDTokenClaimsSet idTokenClaimsSet) {
        if (tokenClaimsSet != null) {
            return tokenClaimsSet.getSessionIdentifier();
        }
        if (idTokenClaimsSet != null && idTokenClaimsSet.getSessionID() != null) {
            return idTokenClaimsSet.getSessionID().getValue();
        }
        return null;
    }

    @Nullable
    protected String getIssuer(@Nullable TokenClaimsSet tokenClaimsSet, @Nullable IDTokenClaimsSet idTokenClaimsSet) {
        if (tokenClaimsSet != null) {
            return tokenClaimsSet.getIssuer();
        }
        if (idTokenClaimsSet != null && idTokenClaimsSet.getIssuer() != null) {
            return idTokenClaimsSet.getIssuer().getValue();
        }
        return null;
    }

    @Nullable
    protected String getSubject(@Nullable TokenClaimsSet tokenClaimsSet, @Nullable IDTokenClaimsSet idTokenClaimsSet) {
        if (tokenClaimsSet != null) {
            return tokenClaimsSet.getSubject();
        }
        if (idTokenClaimsSet != null && idTokenClaimsSet.getSubject() != null) {
            return idTokenClaimsSet.getSubject().getValue();
        }
        return null;
    }

    protected boolean isSupportsLogoutPropagation(@Nullable ProfileRequestContext profileRequestContext) {
        OIDCMetadataContext oidcMetadataContext = this.oidcMetadataContextLookupStrategy.apply(profileRequestContext);
        if (oidcMetadataContext == null || oidcMetadataContext.getClientInformation() == null) {
            this.log.debug("No metadata found, does not support propagation");
            return false;
        }
        OIDCClientInformation clientInformation = oidcMetadataContext.getClientInformation();
        assert (clientInformation != null);
        OIDCClientMetadata metadata = clientInformation.getOIDCMetadata();
        boolean result = metadata.getBackChannelLogoutURI() != null || metadata.getFrontChannelLogoutURI() != null;
        return result;
    }
}

