/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.userinfo.profile.impl;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.id.Subject;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultUserInfoSigningAlgLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCResponseAction;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class AddUserInfoShell
extends AbstractOIDCResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AddUserInfoShell.class);
    @NonnullAfterInit
    private Function<ProfileRequestContext, String> issuerLookupStrategy;
    @Nullable
    private String issuerId;
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @Nullable
    private RelyingPartyContext rpCtx;
    @Nonnull
    private Function<ProfileRequestContext, JWSAlgorithm> userInfoSigAlgStrategy = new DefaultUserInfoSigningAlgLookupFunction();

    public void setUserInfoSigningAlgLookupStrategy(@Nonnull Function<ProfileRequestContext, JWSAlgorithm> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.userInfoSigAlgStrategy = (Function)Constraint.isNotNull(strategy, (String)"User Info Signing Algorithm lookup strategy cannot be null");
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"IssuerLookupStrategy lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.issuerLookupStrategy == null) {
            throw new ComponentInitializationException("Issuer lookup strategy cannot be null");
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.rpCtx = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (this.rpCtx == null) {
            this.log.debug("{} No relying party context associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        this.issuerId = this.issuerLookupStrategy.apply(profileRequestContext);
        if (this.issuerId == null) {
            this.log.error("{} Unable to determine issuer to check audience", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        UserInfo userInfo = new UserInfo(new Subject(oidcResponseContext.getSubject()));
        if (this.userInfoSigAlgStrategy.apply(profileRequestContext) != null) {
            assert (this.rpCtx != null);
            userInfo.setClaim("aud", (Object)this.rpCtx.getRelyingPartyId());
            userInfo.setIssuer(new Issuer(this.issuerId));
        }
        this.log.debug("{} Setting userinfo response shell to response context {}", (Object)this.getLogPrefix(), (Object)userInfo.toJSONObject().toJSONString());
        oidcResponseContext.setUserInfo(userInfo);
    }
}

