/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.userinfo.profile.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.token.support.AccessTokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.userinfo.profile.impl.AbstractOIDCUserInfoValidationResponseAction;
import net.shibboleth.oidc.jwt.claims.ClaimsValidator;
import net.shibboleth.oidc.jwt.claims.JWTValidationException;
import net.shibboleth.oidc.profile.config.navigate.IssuedClaimsValidatorLookupFunction;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidateAccessToken
extends AbstractOIDCUserInfoValidationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateAccessToken.class);
    @Nonnull
    private Function<ProfileRequestContext, ClaimsValidator> claimsValidatorLookupStrategy = new IssuedClaimsValidatorLookupFunction();
    @Nullable
    private ClaimsValidator claimsValidator;

    public void setClaimsValidatorLookupStrategy(@Nonnull Function<ProfileRequestContext, ClaimsValidator> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.claimsValidatorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.claimsValidator = this.claimsValidatorLookupStrategy.apply(profileRequestContext);
        if (this.claimsValidator == null) {
            this.log.error("{} Unable to obtain ClaimsValidator to apply", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        TokenClaimsSet tokenClaims = oidcResponseContext.getAuthorizationGrantClaimsSet();
        if (!(tokenClaims instanceof AccessTokenClaimsSet) || tokenClaims.getClaimsSet() == null) {
            this.log.error("{} Claims validation failed, unable to locate access token claims set to validate", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAcessToken");
            return;
        }
        JWTClaimsSet claimsSet = tokenClaims.getClaimsSet();
        assert (claimsSet != null);
        this.log.debug("{} Validating parsed/decoded claims set: {}", (Object)this.getLogPrefix(), (Object)claimsSet.toString());
        try {
            assert (this.claimsValidator != null);
            this.claimsValidator.validate(claimsSet, profileRequestContext);
        }
        catch (JWTValidationException e) {
            this.log.warn("{} Claims validation failed, token is invalid: {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAcessToken");
            return;
        }
        this.log.debug("{} Access token {} validated", (Object)this.getLogPrefix(), (Object)tokenClaims.getID());
    }
}

