/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.saml.xmlobject.impl;

import com.google.common.base.Strings;
import net.shibboleth.oidc.saml.xmlobject.ApplicationType;
import net.shibboleth.oidc.saml.xmlobject.ClientUri;
import net.shibboleth.oidc.saml.xmlobject.DefaultAcrValue;
import net.shibboleth.oidc.saml.xmlobject.GrantType;
import net.shibboleth.oidc.saml.xmlobject.IdTokenEncryptedResponseAlg;
import net.shibboleth.oidc.saml.xmlobject.IdTokenEncryptedResponseEnc;
import net.shibboleth.oidc.saml.xmlobject.IdTokenSignedResponseAlg;
import net.shibboleth.oidc.saml.xmlobject.InitiateLoginUri;
import net.shibboleth.oidc.saml.xmlobject.JwksUri;
import net.shibboleth.oidc.saml.xmlobject.OAuthRPExtensions;
import net.shibboleth.oidc.saml.xmlobject.PostLogoutRedirectUri;
import net.shibboleth.oidc.saml.xmlobject.RequestObjectEncryptionAlg;
import net.shibboleth.oidc.saml.xmlobject.RequestObjectEncryptionEnc;
import net.shibboleth.oidc.saml.xmlobject.RequestObjectSigningAlg;
import net.shibboleth.oidc.saml.xmlobject.RequestUri;
import net.shibboleth.oidc.saml.xmlobject.ResponseType;
import net.shibboleth.oidc.saml.xmlobject.Scope;
import net.shibboleth.oidc.saml.xmlobject.SectorIdentifierUri;
import net.shibboleth.oidc.saml.xmlobject.SoftwareId;
import net.shibboleth.oidc.saml.xmlobject.SoftwareVersion;
import net.shibboleth.oidc.saml.xmlobject.TokenEndpointAuthMethod;
import net.shibboleth.oidc.saml.xmlobject.TokenEndpointAuthSigningAlg;
import net.shibboleth.oidc.saml.xmlobject.UserInfoEncryptedResponseAlg;
import net.shibboleth.oidc.saml.xmlobject.UserInfoEncryptedResponseEnc;
import net.shibboleth.oidc.saml.xmlobject.UserInfoSignedResponseAlg;
import org.opensaml.core.xml.AttributeExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.common.AbstractSAMLObjectUnmarshaller;
import org.w3c.dom.Attr;

public class OAuthRPExtensionsUnmarshaller
extends AbstractSAMLObjectUnmarshaller {
    protected void processChildElement(XMLObject parentSAMLObject, XMLObject childSAMLObject) throws UnmarshallingException {
        OAuthRPExtensions descriptor = (OAuthRPExtensions)parentSAMLObject;
        if (childSAMLObject instanceof ResponseType) {
            descriptor.getResponseTypes().add((ResponseType)childSAMLObject);
        } else if (childSAMLObject instanceof GrantType) {
            descriptor.getGrantTypes().add((GrantType)childSAMLObject);
        } else if (childSAMLObject instanceof ApplicationType) {
            descriptor.setApplicationType((ApplicationType)childSAMLObject);
        } else if (childSAMLObject instanceof TokenEndpointAuthMethod) {
            descriptor.setTokenEndpointAuthMethod((TokenEndpointAuthMethod)childSAMLObject);
        } else if (childSAMLObject instanceof ClientUri) {
            descriptor.setClientUri((ClientUri)childSAMLObject);
        } else if (childSAMLObject instanceof Scope) {
            descriptor.getScopes().add((Scope)childSAMLObject);
        } else if (childSAMLObject instanceof JwksUri) {
            descriptor.setJwksUri((JwksUri)childSAMLObject);
        } else if (childSAMLObject instanceof SoftwareId) {
            descriptor.setSoftwareId((SoftwareId)childSAMLObject);
        } else if (childSAMLObject instanceof SoftwareVersion) {
            descriptor.setSoftwareVersion((SoftwareVersion)childSAMLObject);
        } else if (childSAMLObject instanceof SectorIdentifierUri) {
            descriptor.setSectorIdentifierUri((SectorIdentifierUri)childSAMLObject);
        } else if (childSAMLObject instanceof IdTokenSignedResponseAlg) {
            descriptor.setIdTokenSignedResponseAlg((IdTokenSignedResponseAlg)childSAMLObject);
        } else if (childSAMLObject instanceof IdTokenEncryptedResponseAlg) {
            descriptor.setIdTokenEncryptedResponseAlg((IdTokenEncryptedResponseAlg)childSAMLObject);
        } else if (childSAMLObject instanceof IdTokenEncryptedResponseEnc) {
            descriptor.setIdTokenEncryptedResponseEnc((IdTokenEncryptedResponseEnc)childSAMLObject);
        } else if (childSAMLObject instanceof UserInfoSignedResponseAlg) {
            descriptor.setUserInfoSignedResponseAlg((UserInfoSignedResponseAlg)childSAMLObject);
        } else if (childSAMLObject instanceof UserInfoEncryptedResponseAlg) {
            descriptor.setUserInfoEncryptedResponseAlg((UserInfoEncryptedResponseAlg)childSAMLObject);
        } else if (childSAMLObject instanceof UserInfoEncryptedResponseEnc) {
            descriptor.setUserInfoEncryptedResponseEnc((UserInfoEncryptedResponseEnc)childSAMLObject);
        } else if (childSAMLObject instanceof RequestObjectSigningAlg) {
            descriptor.setRequestObjectSigningAlg((RequestObjectSigningAlg)childSAMLObject);
        } else if (childSAMLObject instanceof RequestObjectEncryptionAlg) {
            descriptor.setRequestObjectEncryptionAlg((RequestObjectEncryptionAlg)childSAMLObject);
        } else if (childSAMLObject instanceof RequestObjectEncryptionEnc) {
            descriptor.setRequestObjectEncryptionEnc((RequestObjectEncryptionEnc)childSAMLObject);
        } else if (childSAMLObject instanceof TokenEndpointAuthSigningAlg) {
            descriptor.setTokenEndpointAuthSigningAlg((TokenEndpointAuthSigningAlg)childSAMLObject);
        } else if (childSAMLObject instanceof DefaultAcrValue) {
            descriptor.getDefaultAcrValues().add((DefaultAcrValue)childSAMLObject);
        } else if (childSAMLObject instanceof InitiateLoginUri) {
            descriptor.setInitiateLoginUri((InitiateLoginUri)childSAMLObject);
        } else if (childSAMLObject instanceof RequestUri) {
            descriptor.getRequestUris().add((RequestUri)childSAMLObject);
        } else if (childSAMLObject instanceof PostLogoutRedirectUri) {
            descriptor.getPostLogoutRedirectUris().add((PostLogoutRedirectUri)childSAMLObject);
        } else {
            super.processChildElement(parentSAMLObject, childSAMLObject);
        }
    }

    protected void processAttribute(XMLObject samlObject, Attr attribute) throws UnmarshallingException {
        OAuthRPExtensions descriptor = (OAuthRPExtensions)samlObject;
        if (attribute.getNamespaceURI() == null) {
            if (attribute.getLocalName().equals("defaultMaxAge") && !Strings.isNullOrEmpty((String)attribute.getValue())) {
                descriptor.setDefaultMaxAge(Integer.parseInt(attribute.getValue()));
            } else if (attribute.getLocalName().equals("requireAuthTime") && !Strings.isNullOrEmpty((String)attribute.getValue())) {
                descriptor.setRequireAuthTime(Boolean.parseBoolean(attribute.getValue()));
            } else {
                super.processAttribute(samlObject, attribute);
            }
        } else {
            this.processUnknownAttribute((AttributeExtensibleXMLObject)descriptor, attribute);
        }
    }
}

