/*
 * Licensed to the University Corporation for Advanced Internet Development,
 * Inc. (UCAID) under one or more contributor license agreements.  See the
 * NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The UCAID licenses this file to You under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.oidc.saml.xmlobject.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.common.AbstractSAMLObjectMarshaller;
import org.w3c.dom.Element;

import net.shibboleth.oidc.saml.xmlobject.OAuthRPExtensions;

/**
 * Marshaller for {@link OAuthRPExtensions} objects.
 */
public class OAuthRPExtensionsMarshaller extends AbstractSAMLObjectMarshaller {

 // Checkstyle: MethodLength|CyclomaticComplexity OFF
    /** {@inheritDoc} */
    @Override
    protected void marshallAttributes(final XMLObject samlElement, final Element domElement)
            throws MarshallingException {
        final OAuthRPExtensions rpExtensions = (OAuthRPExtensions) samlElement;

        if (rpExtensions.getTokenEndpointAuthMethod() != null) {
            domElement.setAttributeNS(null, OAuthRPExtensions.TOKEN_ENDPOINT_AUTH_METHOD_ATTRIB_NAME,
                    rpExtensions.getTokenEndpointAuthMethod());
        }

        if (rpExtensions.getGrantTypes() != null) {
            domElement.setAttributeNS(null, OAuthRPExtensions.GRANT_TYPES_ATTRIB_NAME,
                    rpExtensions.getGrantTypes());
        }

        if (rpExtensions.getResponseTypes() != null) {
            domElement.setAttributeNS(null, OAuthRPExtensions.RESPONSE_TYPES_ATTRIB_NAME,
                    rpExtensions.getResponseTypes());
        }

        if (rpExtensions.getApplicationType() != null) {
            domElement.setAttributeNS(null, OAuthRPExtensions.APPLICATION_TYPE_ATTRIB_NAME,
                    rpExtensions.getApplicationType());
        }

        if (rpExtensions.getClientUri() != null) {
            domElement.setAttributeNS(null, OAuthRPExtensions.CLIENT_URI_ATTRIB_NAME,
                    rpExtensions.getClientUri());
        }

        if (rpExtensions.getScopes() != null) {
            domElement.setAttributeNS(null, OAuthRPExtensions.SCOPES_ATTRIB_NAME,
                    rpExtensions.getScopes());
        }

        if (rpExtensions.getSoftwareId() != null) {
            domElement.setAttributeNS(null, OAuthRPExtensions.SOFTWARE_ID_ATTRIB_NAME,
                    rpExtensions.getSoftwareId());
        }

        if (rpExtensions.getSoftwareVersion() != null) {
            domElement.setAttributeNS(null, OAuthRPExtensions.SOFTWARE_VERSION_ATTRIB_NAME,
                    rpExtensions.getSoftwareVersion());
        }

        if (rpExtensions.getSectorIdentifierUri() != null) {
            domElement.setAttributeNS(null, OAuthRPExtensions.SECTOR_IDENTIFIER_URI_ATTRIB_NAME,
                    rpExtensions.getSectorIdentifierUri());
        }

        if (rpExtensions.getIdTokenSignedResponseAlg() != null) {
            domElement.setAttributeNS(null, OAuthRPExtensions.ID_TOKEN_SIGNED_RESPONSE_ALG_ATTRIB_NAME,
                    rpExtensions.getIdTokenSignedResponseAlg());
        }

        if (rpExtensions.getIdTokenEncryptedResponseAlg() != null) {
            domElement.setAttributeNS(null, OAuthRPExtensions.ID_TOKEN_ENCRYPTED_RESPONSE_ALG_ATTRIB_NAME,
                    rpExtensions.getIdTokenEncryptedResponseAlg());
        }

        if (rpExtensions.getIdTokenEncryptedResponseEnc() != null) {
            domElement.setAttributeNS(null, OAuthRPExtensions.ID_TOKEN_ENCRYPTED_RESPONSE_ENC_ATTRIB_NAME,
                    rpExtensions.getIdTokenEncryptedResponseEnc());
        }

        if (rpExtensions.getUserInfoSignedResponseAlg() != null) {
            domElement.setAttributeNS(null, OAuthRPExtensions.USERINFO_SIGNED_RESPONSE_ALG_ATTRIB_NAME,
                    rpExtensions.getUserInfoSignedResponseAlg());
        }

        if (rpExtensions.getUserInfoEncryptedResponseAlg() != null) {
            domElement.setAttributeNS(null, OAuthRPExtensions.USERINFO_ENCRYPTED_RESPONSE_ALG_ATTRIB_NAME,
                    rpExtensions.getUserInfoEncryptedResponseAlg());
        }

        if (rpExtensions.getUserInfoEncryptedResponseEnc() != null) {
            domElement.setAttributeNS(null, OAuthRPExtensions.USERINFO_ENCRYPTED_RESPONSE_ENC_ATTRIB_NAME,
                    rpExtensions.getUserInfoEncryptedResponseEnc());
        }

        if (rpExtensions.getRequestObjectSigningAlg() != null) {
            domElement.setAttributeNS(null, OAuthRPExtensions.REQUEST_OBJECT_SIGNING_ALG_ATTRIB_NAME,
                    rpExtensions.getRequestObjectSigningAlg());
        }

        if (rpExtensions.getRequestObjectEncryptionAlg() != null) {
            domElement.setAttributeNS(null, OAuthRPExtensions.REQUEST_OBJECT_ENCRYPTION_ALG_ATTRIB_NAME,
                    rpExtensions.getRequestObjectEncryptionAlg());
        }

        if (rpExtensions.getRequestObjectEncryptionEnc() != null) {
            domElement.setAttributeNS(null, OAuthRPExtensions.REQUEST_OBJECT_ENCRYPTION_ENC_ATTRIB_NAME,
                    rpExtensions.getRequestObjectEncryptionEnc());
        }

        if (rpExtensions.getTokenEndpointAuthSigningAlg() != null) {
            domElement.setAttributeNS(null, OAuthRPExtensions.TOKEN_ENDPOINT_AUTH_SIGNING_ALG_ATTRIB_NAME,
                    rpExtensions.getTokenEndpointAuthSigningAlg());
        }

        if (rpExtensions.getInitiateLoginUri() != null) {
            domElement.setAttributeNS(null, OAuthRPExtensions.INITIATE_LOGIN_URI_ATTRIB_NAME,
                    rpExtensions.getInitiateLoginUri());
        }

        if (rpExtensions.getDefaultMaxAge() != 0) {
            domElement.setAttributeNS(null, OAuthRPExtensions.DEFAULT_MAX_AGE_ATTRIB_NAME,
                    Integer.toString(rpExtensions.getDefaultMaxAge()));
        }

        if (rpExtensions.isRequireAuthTime()) {
            domElement.setAttributeNS(null, OAuthRPExtensions.REQUIRE_AUTH_TIME_ATTRIB_NAME,
                    Boolean.toString(rpExtensions.isRequireAuthTime()));
        }

        marshallUnknownAttributes(rpExtensions, domElement);
    }
    
 // Checkstyle: MethodLength|CyclomaticComplexity ON
}
