/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.cli;

import com.beust.jcommander.Parameter;
import com.google.common.base.Strings;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.cli.CommandLineArguments;
import net.shibboleth.shared.collection.CollectionSupport;
import org.slf4j.Logger;

public abstract class AbstractCommandLineArguments
implements CommandLineArguments {
    @Parameter
    @Nonnull
    private List<String> otherArgs = new ArrayList<String>();
    @Parameter(names={"--verbose"})
    private boolean verbose;
    @Parameter(names={"--quiet"})
    private boolean quiet;
    @Parameter(names={"--logConfig"})
    @Nullable
    private String logConfig;
    @Parameter(names={"-?", "--help"}, help=true)
    private boolean help;
    @Parameter(names={"--version"})
    private boolean version;
    @Parameter(names={"--ansi"})
    private boolean ansi;
    @Parameter(names={"--propertyFiles"})
    @Nonnull
    private List<String> propertySources = new ArrayList<String>();
    @Parameter(names={"--lang"})
    @Nullable
    private String languageRanges;

    @Nonnull
    public abstract Logger getLog();

    @Override
    public boolean isVerboseOutput() {
        return this.verbose;
    }

    @Override
    public boolean isQuietOutput() {
        return this.quiet;
    }

    @Override
    @Nullable
    public String getLoggingConfiguration() {
        return this.logConfig;
    }

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public boolean isVersion() {
        return this.version;
    }

    @Override
    public boolean isANSI() {
        return this.ansi;
    }

    @Override
    @Nonnull
    @Unmodifiable
    @NotLive
    public List<String> getPropertyFiles() {
        return this.propertySources;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public List<Locale.LanguageRange> getLanguageRanges() {
        if (Strings.isNullOrEmpty((String)this.languageRanges)) {
            return CollectionSupport.emptyList();
        }
        return CollectionSupport.copyToList(Locale.LanguageRange.parse(this.languageRanges));
    }

    @Override
    @Nonnull
    @Unmodifiable
    @NotLive
    public List<String> getOtherArgs() {
        return this.otherArgs;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        if (this.isVerboseOutput() && this.isQuietOutput()) {
            throw new IllegalArgumentException("Verbose and quiet output are mutually exclusive");
        }
    }

    @Override
    public void printHelp(@Nonnull PrintStream out) {
        out.println();
        out.println("==== Command Line Options ====");
        out.println();
        out.println(String.format("  --%-20s %s", "help", "Prints this help information"));
        out.println(String.format("  --%-20s %s", "version", "Prints version"));
        out.println(String.format("  --%-20s %s", "ansi", "Use ANSI color codes"));
        out.println(String.format("  --%-20s %s", "lang", "Language range for i18n"));
        out.println(String.format("  --%-20s %s", "propertyFiles", "Comma-separated list of Spring property files"));
        out.println();
        out.println("Logging Options - these options are mutually exclusive");
        out.println(String.format("  --%-20s %s", "verbose", "Turn on verbose messages."));
        out.println(String.format("  --%-20s %s", "quiet", "Restrict output messages to errors and warnings."));
        out.println();
        out.println(String.format("  --%-20s %s", "logConfig", "Specifies a logback configuration file to use to configure logging."));
        out.println();
    }
}

