/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.context.logic;

import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import net.shibboleth.idp.attribute.DateTimeAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.context.logic.DateAttributePredicate;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class DateAttributePredicateTest {
    private final DateTimeFormatter javaformatter = DateTimeFormatter.ISO_ZONED_DATE_TIME;

    @DataProvider(name="test-data-java")
    public Object[][] provideTestDataJava() {
        return new Object[][]{{new DateAttributePredicate("expirationDate", this.javaformatter), "expirationDate", this.javaDateStrings(Duration.ofDays(1L)), true}, {new DateAttributePredicate("expirationDate", this.javaformatter), "expirationDate", this.javaDateStrings(Duration.ZERO), false}, {new DateAttributePredicate("expirationDate", this.javaformatter), "expirationDate", this.javaDateStrings(Duration.ofDays(-1L)), false}, {this.newJavaPredicate("expirationDate", Duration.ofDays(90L)), "expirationDate", this.javaDateStrings(Duration.ofDays(91L)), true}, {this.newJavaPredicate("expirationDate", Duration.ofDays(-30L)), "expirationDate", this.javaDateStrings(Duration.ofDays(29L)), false}};
    }

    @Test(dataProvider="test-data-java")
    public void testJavaTime(DateAttributePredicate predicate, String attribute, String[] values, boolean expected) throws Exception {
        Assert.assertEquals((boolean)predicate.test(this.createProfileRequestContext(attribute, values, null)), (boolean)expected);
    }

    @Test
    public void testDateTimeValues() {
        DateAttributePredicate predicate = new DateAttributePredicate("test");
        Assert.assertTrue((boolean)predicate.test(this.createProfileRequestContext("test", null, new Instant[]{Instant.now().plus(Duration.ofMinutes(5L))})));
        predicate.setOffset(Duration.ofMinutes(-10L));
        Assert.assertFalse((boolean)predicate.test(this.createProfileRequestContext("test", null, new Instant[]{Instant.now().plus(Duration.ofMinutes(5L))})));
    }

    private ProfileRequestContext createProfileRequestContext(String name, String[] values, Instant[] dtvalues) {
        ProfileRequestContext prc = new ProfileRequestContext();
        RelyingPartyContext rpc = new RelyingPartyContext();
        IdPAttribute attribute = new IdPAttribute(name);
        ArrayList<Object> attributeValues = new ArrayList<Object>();
        if (values != null) {
            for (String string : values) {
                attributeValues.add(new StringAttributeValue(string));
            }
        }
        if (dtvalues != null) {
            for (Instant instant : dtvalues) {
                attributeValues.add(new DateTimeAttributeValue(instant));
            }
        }
        attribute.setValues(attributeValues);
        AttributeContext ac = new AttributeContext();
        ac.setIdPAttributes((Collection)CollectionSupport.singletonList((Object)attribute));
        ac.setUnfilteredIdPAttributes((Collection)CollectionSupport.singletonList((Object)attribute));
        rpc.addSubcontext((BaseContext)ac);
        prc.addSubcontext((BaseContext)rpc);
        return prc;
    }

    private String[] javaDateStrings(Duration ... offsets) {
        String[] dates = new String[offsets.length];
        for (int i = 0; i < offsets.length; ++i) {
            dates[i] = this.javaformatter.format(ZonedDateTime.now().plus(offsets[i]));
        }
        return dates;
    }

    private DateAttributePredicate newJavaPredicate(String attribute, Duration offset) {
        DateAttributePredicate p = new DateAttributePredicate(attribute, this.javaformatter);
        p.setOffset(offset);
        return p;
    }
}

