/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.context.logic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.context.logic.DynamicAttributePredicate;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.FunctionSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DynamicAttributePredicateTest {
    @Test
    public void testInvalid() {
        ProfileRequestContext prc = this.createProfileRequestContext("foo", List.of("bar", "baz"));
        DynamicAttributePredicate predicate = new DynamicAttributePredicate();
        predicate.setAttributeFunctionMap(Map.of("foo", CollectionSupport.singleton((Object)FunctionSupport.constant(List.of(Integer.valueOf(10))))));
        Assert.assertFalse((boolean)predicate.test(prc));
        predicate.setAttributeFunctionMap(Map.of("foo", CollectionSupport.singleton((Object)FunctionSupport.constant((Object)10))));
        Assert.assertFalse((boolean)predicate.test(prc));
    }

    @Test
    public void testString() {
        ProfileRequestContext prc = this.createProfileRequestContext("foo", List.of("bar", "baz"));
        DynamicAttributePredicate predicate = new DynamicAttributePredicate();
        predicate.setAttributeFunctionMap(Map.of("foo2", CollectionSupport.singleton((Object)FunctionSupport.constant(List.of("bar")))));
        Assert.assertFalse((boolean)predicate.test(prc));
        predicate.setAttributeFunctionMap(Map.of("foo2", CollectionSupport.singleton((Object)FunctionSupport.constant((Object)"bar"))));
        Assert.assertFalse((boolean)predicate.test(prc));
        predicate.setAttributeFunctionMap(Map.of("foo2", CollectionSupport.singleton((Object)FunctionSupport.constant((Object)"*"))));
        Assert.assertFalse((boolean)predicate.test(prc));
        predicate.setAttributeFunctionMap(Map.of("foo", CollectionSupport.singleton((Object)FunctionSupport.constant((Object)"*"))));
        Assert.assertTrue((boolean)predicate.test(prc));
        predicate.setAttributeFunctionMap(Map.of("foo", CollectionSupport.singleton((Object)FunctionSupport.constant(List.of("bar", "baz")))));
        Assert.assertTrue((boolean)predicate.test(prc));
    }

    private ProfileRequestContext createProfileRequestContext(String name, Collection<String> values) {
        ProfileRequestContext prc = new ProfileRequestContext();
        RelyingPartyContext rpc = new RelyingPartyContext();
        IdPAttribute attribute = new IdPAttribute(name);
        ArrayList<Object> attributeValues = new ArrayList<Object>();
        for (String value : values) {
            int i = value.indexOf(64);
            if (i == -1) {
                attributeValues.add(new StringAttributeValue(value));
                continue;
            }
            attributeValues.add(new ScopedStringAttributeValue(value.substring(0, i), value.substring(i + 1)));
        }
        attribute.setValues(attributeValues);
        AttributeContext ac = new AttributeContext();
        ac.setIdPAttributes((Collection)CollectionSupport.singletonList((Object)attribute));
        ac.setUnfilteredIdPAttributes((Collection)CollectionSupport.singletonList((Object)attribute));
        rpc.addSubcontext((BaseContext)ac);
        prc.addSubcontext((BaseContext)rpc);
        return prc;
    }
}

