/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.context.logic;

import java.util.Map;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.context.logic.LoopDetectionPredicate;
import net.shibboleth.shared.logic.FunctionSupport;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.profile.context.ProfileRequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class LoopDetectionPredicateTest
extends OpenSAMLInitBaseTestCase {
    private ProfileRequestContext prc;
    private RelyingPartyContext rpCtx;
    private LoopDetectionPredicate pred;

    @BeforeMethod
    public void setUp() {
        this.prc = new ProfileRequestContext();
        this.rpCtx = (RelyingPartyContext)this.prc.ensureSubcontext(RelyingPartyContext.class);
        this.pred = new LoopDetectionPredicate();
        this.pred.setUsernameLookupStrategy(FunctionSupport.constant((Object)"jdoe.1"));
    }

    @Test
    public void testNoMap() {
        Assert.assertFalse((boolean)this.pred.test(this.prc));
        this.rpCtx.setRelyingPartyId("foo");
        Assert.assertFalse((boolean)this.pred.test(this.prc));
    }

    @Test
    public void testNoMatch() {
        this.pred.setRelyingPartyMap(Map.of("bar", "bar"));
        this.rpCtx.setRelyingPartyId("foo");
        Assert.assertFalse((boolean)this.pred.test(this.prc));
    }

    @Test
    public void testMatch() {
        this.pred.setRelyingPartyMap(Map.of("foo", "foo"));
        this.rpCtx.setRelyingPartyId("foo");
        Assert.assertFalse((boolean)this.pred.test(this.prc));
    }

    @Test
    public void testExceed() throws InterruptedException {
        this.pred.setRelyingPartyMap(Map.of("bar", "bar"));
        this.rpCtx.setRelyingPartyId("bar");
        for (int i = 0; i < 20; ++i) {
            Assert.assertFalse((boolean)this.pred.test(this.prc));
        }
        Assert.assertTrue((boolean)this.pred.test(this.prc));
    }
}

