/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.context.logic;

import java.util.Collection;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.context.logic.RelyingPartyIdPredicate;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.spring.context.FilesystemGenericApplicationContext;
import net.shibboleth.shared.spring.custom.SchemaTypeAwareXMLBeanDefinitionReader;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RelyingPartyIdPredicateTest {
    private ProfileRequestContext prc;
    private RelyingPartyContext rpCtx;

    @BeforeMethod
    public void setUp() {
        this.prc = new ProfileRequestContext();
        this.rpCtx = (RelyingPartyContext)this.prc.ensureSubcontext(RelyingPartyContext.class);
    }

    @Test
    public void testNone() throws ComponentInitializationException {
        RelyingPartyIdPredicate pred = new RelyingPartyIdPredicate((Collection)CollectionSupport.emptySet());
        Assert.assertFalse((boolean)pred.test((Object)this.prc));
        this.rpCtx.setRelyingPartyId("foo");
        Assert.assertFalse((boolean)pred.test((Object)this.prc));
    }

    @Test
    public void testMatch() throws ComponentInitializationException {
        RelyingPartyIdPredicate pred = new RelyingPartyIdPredicate((Collection)CollectionSupport.singleton((Object)"foo"));
        Assert.assertFalse((boolean)pred.test((Object)this.prc));
        this.rpCtx.setRelyingPartyId("foo");
        Assert.assertTrue((boolean)pred.test((Object)this.prc));
    }

    @Test
    public void testNoMatch() throws ComponentInitializationException {
        RelyingPartyIdPredicate pred = new RelyingPartyIdPredicate((Collection)CollectionSupport.singleton((Object)"bar"));
        Assert.assertFalse((boolean)pred.test((Object)this.prc));
        this.rpCtx.setRelyingPartyId("foo");
        Assert.assertFalse((boolean)pred.test((Object)this.prc));
    }

    @Test
    public void springConstructors() {
        try (FilesystemGenericApplicationContext context = new FilesystemGenericApplicationContext();){
            context.setDisplayName("ApplicationContext: Matcher");
            SchemaTypeAwareXMLBeanDefinitionReader beanDefinitionReader = new SchemaTypeAwareXMLBeanDefinitionReader((BeanDefinitionRegistry)context);
            beanDefinitionReader.loadBeanDefinitions("net/shibboleth/profile/context/logic/relyingPartyIdPredicates.xml");
            context.refresh();
            RelyingPartyIdPredicate bean = (RelyingPartyIdPredicate)context.getBean("candidate", RelyingPartyIdPredicate.class);
            Assert.assertTrue((boolean)this.testCandidate(bean, "Single"));
            Assert.assertFalse((boolean)this.testCandidate(bean, "Double"));
            Assert.assertFalse((boolean)this.testCandidate(bean, "Elephant"));
            bean = (RelyingPartyIdPredicate)context.getBean("candidates", RelyingPartyIdPredicate.class);
            Assert.assertTrue((boolean)this.testCandidate(bean, "Single"));
            Assert.assertTrue((boolean)this.testCandidate(bean, "Double"));
            Assert.assertFalse((boolean)this.testCandidate(bean, "Elephant"));
            bean = (RelyingPartyIdPredicate)context.getBean("pred", RelyingPartyIdPredicate.class);
            Assert.assertTrue((boolean)this.testCandidate(bean, "Single"));
            Assert.assertTrue((boolean)this.testCandidate(bean, "Double"));
            Assert.assertTrue((boolean)this.testCandidate(bean, "Elephant"));
            bean = (RelyingPartyIdPredicate)context.getBean("candidate_0", RelyingPartyIdPredicate.class);
            Assert.assertTrue((boolean)this.testCandidate(bean, "Single"));
            Assert.assertFalse((boolean)this.testCandidate(bean, "Double"));
            Assert.assertFalse((boolean)this.testCandidate(bean, "Elephant"));
            bean = (RelyingPartyIdPredicate)context.getBean("candidates_0", RelyingPartyIdPredicate.class);
            Assert.assertTrue((boolean)this.testCandidate(bean, "Single"));
            Assert.assertTrue((boolean)this.testCandidate(bean, "Double"));
            Assert.assertFalse((boolean)this.testCandidate(bean, "Elephant"));
            bean = (RelyingPartyIdPredicate)context.getBean("pred_0", RelyingPartyIdPredicate.class);
            Assert.assertTrue((boolean)this.testCandidate(bean, "Single"));
            Assert.assertTrue((boolean)this.testCandidate(bean, "Double"));
            Assert.assertTrue((boolean)this.testCandidate(bean, "Elephant"));
        }
    }

    private boolean testCandidate(RelyingPartyIdPredicate rpIdPredicate, String rpId) {
        ProfileRequestContext prc = new ProfileRequestContext();
        RelyingPartyContext rpc = (RelyingPartyContext)prc.ensureSubcontext(RelyingPartyContext.class);
        rpc.setRelyingPartyId(rpId);
        return rpIdPredicate.test((Object)prc);
    }
}

