/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.context.logic;

import java.util.Collection;
import javax.script.ScriptException;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.context.logic.ScriptedPredicate;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.spring.util.ApplicationContextBuilder;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.context.support.GenericApplicationContext;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ScriptedPredicateTest {
    private ProfileRequestContext withChild;
    private ProfileRequestContext noChild;

    @BeforeClass
    public void setup() {
        this.withChild = new ProfileRequestContext();
        this.withChild.ensureSubcontext(RelyingPartyContext.class);
        this.noChild = new ProfileRequestContext();
    }

    @Test
    public void simple() throws ScriptException, ComponentInitializationException {
        ScriptedPredicate test = ScriptedPredicate.inlineScript((String)"new java.lang.Boolean(true);");
        Assert.assertTrue((boolean)test.test((Object)this.withChild));
        test = ScriptedPredicate.inlineScript((String)"true");
        Assert.assertTrue((boolean)test.test((Object)this.withChild));
        test = ScriptedPredicate.inlineScript((String)"false");
        Assert.assertFalse((boolean)test.test((Object)this.withChild));
        test = ScriptedPredicate.inlineScript((String)"\"thirty\"");
        Assert.assertFalse((boolean)test.test((Object)this.withChild));
    }

    @Test
    public void custom() throws ScriptException, ComponentInitializationException {
        ScriptedPredicate test = ScriptedPredicate.inlineScript((String)"custom;");
        test.setCustomObject((Object)true);
        Assert.assertTrue((boolean)test.test((Object)this.withChild));
        test.setCustomObject((Object)false);
        Assert.assertFalse((boolean)test.test((Object)this.withChild));
    }

    @Test
    public void inlineBean() throws ScriptException {
        ApplicationContextBuilder builder = new ApplicationContextBuilder();
        builder.setUnresolvedServiceConfigurations((Collection)CollectionSupport.singletonList((Object)"/net/shibboleth/profile/context/logic/inlineBean.xml"));
        try (GenericApplicationContext ctx = builder.build();){
            ScriptedPredicate rule = (ScriptedPredicate)ctx.getBean(ScriptedPredicate.class);
            Assert.assertTrue((boolean)rule.test((Object)this.withChild));
            Assert.assertFalse((boolean)rule.test((Object)this.noChild));
        }
    }

    @Test
    public void resourceBean() throws ScriptException {
        ApplicationContextBuilder builder = new ApplicationContextBuilder();
        builder.setUnresolvedServiceConfigurations((Collection)CollectionSupport.singletonList((Object)"/net/shibboleth/profile/context/logic/resourceBean.xml"));
        try (GenericApplicationContext ctx = builder.build();){
            ScriptedPredicate rule = (ScriptedPredicate)ctx.getBean(ScriptedPredicate.class);
            Assert.assertTrue((boolean)rule.test((Object)this.withChild));
            Assert.assertFalse((boolean)rule.test((Object)this.noChild));
        }
    }
}

