/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.context.navigate;

import javax.script.ScriptException;
import net.shibboleth.profile.context.navigate.ScriptedContextLookupFunction;
import net.shibboleth.shared.component.ComponentInitializationException;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ScriptedContextLookupFunctionTest {
    static final String STRING_RETURN = "JavaString=Java.type(\"java.lang.String\"); new JavaString(\"String\");";
    static final String INTEGER_RETURN = "JavaInteger=Java.type(\"java.lang.Integer\"); new JavaInteger(37);";

    @Test
    public void simpleScript() throws ScriptException, ComponentInitializationException {
        ProfileRequestContext prc = new ProfileRequestContext();
        Object string = ScriptedContextLookupFunction.inlineScript((String)STRING_RETURN).apply((BaseContext)prc);
        String s = (String)string;
        Assert.assertEquals((String)s, (String)"String");
        Integer integer = (Integer)ScriptedContextLookupFunction.inlineScript((String)INTEGER_RETURN).apply((BaseContext)prc);
        Assert.assertEquals((int)integer, (int)37);
    }

    @Test
    public void custom() throws ScriptException, ComponentInitializationException {
        ProfileRequestContext prc = new ProfileRequestContext();
        ScriptedContextLookupFunction script = ScriptedContextLookupFunction.inlineScript((String)"custom;");
        script.setCustomObject((Object)"String");
        Assert.assertEquals((Object)script.apply((BaseContext)prc), (Object)"String");
        script.setCustomObject((Object)37);
        Assert.assertEquals((Object)script.apply((BaseContext)prc), (Object)37);
    }

    @Test
    public void withType() throws Exception {
        ProfileRequestContext prc = new ProfileRequestContext();
        ScriptedContextLookupFunction script1 = ScriptedContextLookupFunction.inlineScript((String)STRING_RETURN, Object.class);
        String string = (String)script1.apply((BaseContext)prc);
        Assert.assertEquals((String)string, (String)"String");
        Assert.assertEquals((Object)ScriptedContextLookupFunction.inlineScript((String)STRING_RETURN, String.class).apply((BaseContext)prc), (Object)"String");
        Assert.assertNull((Object)ScriptedContextLookupFunction.inlineScript((String)STRING_RETURN, Integer.class).apply((BaseContext)prc));
        Integer integer = (Integer)ScriptedContextLookupFunction.inlineScript((String)INTEGER_RETURN).apply((BaseContext)prc);
        Assert.assertEquals((int)integer, (int)37);
    }

    @Test
    public void messageContext() throws ScriptException, ComponentInitializationException {
        ScriptedContextLookupFunction script1 = ScriptedContextLookupFunction.inlineMessageContextScript((String)STRING_RETURN, Object.class);
        Assert.assertEquals((Object)script1.apply((BaseContext)new MessageContext()), (Object)"String");
        Assert.assertEquals((Object)script1.apply(null), (Object)"String");
    }
}

