/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.service;

import java.time.Duration;
import java.time.Instant;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.component.UnmodifiableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.TimerSupport;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.service.ServiceException;
import org.slf4j.Logger;

public abstract class AbstractReloadableService<T>
extends AbstractIdentifiableInitializableComponent
implements ReloadableService<T>,
UnmodifiableComponent {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractReloadableService.class);
    @Nonnull
    private Duration reloadCheckDelay;
    @Nullable
    private Timer reloadTaskTimer;
    @Nullable
    private Timer internalTaskTimer;
    @Nullable
    private ServiceReloadTask reloadTask;
    @Nullable
    private Instant lastReloadInstant;
    @Nullable
    private Instant lastSuccessfulReleaseInstant;
    @Nullable
    private Throwable reloadFailureCause;
    private boolean failFast;
    @Nullable
    private String logPrefix;

    public AbstractReloadableService() {
        assert (Duration.ZERO != null);
        this.reloadCheckDelay = Duration.ZERO;
    }

    @Nonnull
    public Duration getReloadCheckDelay() {
        return this.reloadCheckDelay;
    }

    public void setReloadCheckDelay(@Nonnull Duration delay) {
        this.checkSetterPreconditions();
        this.reloadCheckDelay = (Duration)Constraint.isNotNull((Object)delay, (String)"Delay cannot be null");
    }

    @Nullable
    public Timer getReloadTaskTimer() {
        return this.reloadTaskTimer;
    }

    public void setReloadTaskTimer(@Nullable Timer timer) {
        this.checkSetterPreconditions();
        this.reloadTaskTimer = timer;
    }

    @Override
    @Nullable
    public Instant getLastReloadAttemptInstant() {
        return this.lastReloadInstant;
    }

    @Override
    @Nullable
    public Instant getLastSuccessfulReloadInstant() {
        return this.lastSuccessfulReleaseInstant;
    }

    @Override
    @Nullable
    public Throwable getReloadFailureCause() {
        return this.reloadFailureCause;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean value) {
        this.checkSetterPreconditions();
        this.failFast = value;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.log.info("{} Performing initial load", (Object)this.getLogPrefix());
        try {
            this.lastReloadInstant = Instant.now();
            this.doReload();
            this.lastSuccessfulReleaseInstant = this.lastReloadInstant;
        }
        catch (ServiceException e) {
            if (this.isFailFast()) {
                throw new ComponentInitializationException(this.getLogPrefix() + " could not perform initial load", (Exception)e);
            }
            this.log.error("{} Initial load failed", (Object)this.getLogPrefix(), (Object)e);
            this.reloadFailureCause = e;
            if (this.reloadCheckDelay.isNegative() || this.reloadCheckDelay.isZero()) {
                this.log.error("{} No further attempts will be made to reload", (Object)this.getLogPrefix());
            } else {
                this.log.info("{} Continuing to poll configuration", (Object)this.getLogPrefix());
            }
        }
        catch (Exception e) {
            throw new ComponentInitializationException(this.getLogPrefix() + " Unexpected error during initial load", e);
        }
        if (!this.reloadCheckDelay.isNegative() && !this.reloadCheckDelay.isZero()) {
            if (null == this.reloadTaskTimer) {
                this.log.debug("{} No reload task timer specified, creating default", (Object)this.getLogPrefix());
                this.internalTaskTimer = new Timer(TimerSupport.getTimerName((Object)this), true);
            } else {
                this.internalTaskTimer = this.reloadTaskTimer;
            }
            this.log.info("{} Reload interval set to: {}, starting refresh thread", (Object)this.getLogPrefix(), (Object)this.reloadCheckDelay);
            this.reloadTask = new ServiceReloadTask();
            assert (this.internalTaskTimer != null);
            this.internalTaskTimer.schedule((TimerTask)this.reloadTask, this.reloadCheckDelay.toMillis(), this.reloadCheckDelay.toMillis());
        }
    }

    protected void doDestroy() {
        this.log.info("{} Starting shutdown", (Object)this.getLogPrefix());
        if (this.reloadTask != null) {
            this.reloadTask.cancel();
            this.reloadTask = null;
        }
        if (this.reloadTaskTimer == null && this.internalTaskTimer != null) {
            this.internalTaskTimer.cancel();
        }
        this.internalTaskTimer = null;
        this.log.info("{} Completing shutdown", (Object)this.getLogPrefix());
        super.doDestroy();
    }

    @Override
    public final void reload() {
        Instant now;
        this.lastReloadInstant = now = Instant.now();
        try {
            this.doReload();
            this.lastSuccessfulReleaseInstant = now;
            this.reloadFailureCause = null;
        }
        catch (ServiceException e) {
            this.log.error("{} Reload for {} failed", new Object[]{this.getLogPrefix(), this.getId(), e});
            this.reloadFailureCause = e;
            throw e;
        }
    }

    protected abstract boolean shouldReload();

    protected void doReload() {
        this.log.info("{} Reloading service configuration", (Object)this.getLogPrefix());
    }

    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        String prefix = this.logPrefix;
        if (null == prefix) {
            if (this.getId() != null) {
                StringBuilder builder = new StringBuilder("Service '").append(this.getId()).append("':");
                prefix = builder.toString();
                assert (prefix != null);
                if (null == this.logPrefix) {
                    this.logPrefix = prefix;
                }
            } else {
                prefix = "Service:";
            }
        }
        return prefix;
    }

    protected class ServiceReloadTask
    extends TimerTask {
        protected ServiceReloadTask() {
        }

        @Override
        public void run() {
            if (AbstractReloadableService.this.shouldReload()) {
                try {
                    AbstractReloadableService.this.reload();
                }
                catch (ServiceException se) {
                    AbstractReloadableService.this.log.debug("{} Previously logged error during reload", (Object)AbstractReloadableService.this.getLogPrefix(), (Object)se);
                }
                catch (Throwable t) {
                    AbstractReloadableService.this.log.error("{} Unexpected error during reload", (Object)AbstractReloadableService.this.getLogPrefix(), (Object)t);
                }
            }
        }
    }
}

