/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.service.impl;

import javax.annotation.Nonnull;
import net.shibboleth.shared.component.IdentifiedComponent;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.spring.service.AbstractServiceableComponent;

public class SpringServiceableComponent<T>
extends AbstractServiceableComponent<T> {
    @Nonnull
    private final T theComponent;

    public SpringServiceableComponent(@Nonnull T what) {
        this.theComponent = what;
        String id = null;
        if (what instanceof IdentifiedComponent) {
            IdentifiedComponent c = (IdentifiedComponent)what;
            id = c.getId();
        }
        if (id != null) {
            this.setId(id);
        } else {
            String generatedId = what.toString() + Long.toString(System.currentTimeMillis());
            LoggerFactory.getLogger(SpringServiceableComponent.class).debug("Generated id {} for object of type {}", what.getClass(), (Object)generatedId);
            this.setId(generatedId);
        }
    }

    @Override
    @Nonnull
    public T getComponent() {
        return this.theComponent;
    }
}

