/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.service;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.NonnullFunction;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.spring.service.AbstractServiceableComponent;
import net.shibboleth.shared.spring.service.ApplicationContextServiceableComponent;
import org.springframework.context.ApplicationContext;

public class ApplicationContextServiceStrategy
implements NonnullFunction<ApplicationContext, AbstractServiceableComponent<ApplicationContext>> {
    @Nonnull
    public AbstractServiceableComponent<ApplicationContext> apply(@Nullable ApplicationContext appContext) {
        if (appContext != null) {
            ApplicationContextServiceableComponent wrapper = new ApplicationContextServiceableComponent();
            wrapper.setApplicationContext(appContext);
            String id = appContext.getId();
            if (id != null) {
                wrapper.setId(id);
            } else {
                wrapper.setId(appContext.getApplicationName());
            }
            try {
                wrapper.initialize();
                return wrapper;
            }
            catch (ComponentInitializationException e) {
                throw new ServiceException("Unable to initialize component wraper for ApplicationContext " + appContext.getDisplayName(), (Exception)((Object)e));
            }
        }
        throw new ServiceException("Unable to initialize component wraper for absent ApplicationContext");
    }
}

