/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.service;

import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.NonnullFunction;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.service.AbstractReloadableService;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.spring.service.AbstractServiceableComponent;
import net.shibboleth.shared.spring.service.ClassBasedServiceStrategy;
import net.shibboleth.shared.spring.util.ApplicationContextBuilder;
import org.slf4j.Logger;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.Lifecycle;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.io.Resource;

@ThreadSafe
public class ReloadableSpringService<T>
extends AbstractReloadableService<T>
implements ApplicationContextAware,
BeanNameAware,
Lifecycle {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ReloadableSpringService.class);
    @Nonnull
    private List<Resource> serviceConfigurations;
    @Nonnull
    private List<BeanFactoryPostProcessor> factoryPostProcessors;
    @Nonnull
    private List<BeanPostProcessor> postProcessors;
    @Nonnull
    private Collection<String> beanProfiles;
    @Nullable
    private ConversionService conversionService;
    @Nonnull
    private final Class<T> theClaz;
    @Nonnull
    private final NonnullFunction<ApplicationContext, AbstractServiceableComponent<T>> serviceStrategy;
    @Nullable
    private ApplicationContext parentContext;
    @Nullable
    private String beanName;
    @Nullable
    private AbstractServiceableComponent<T> cachedComponent;
    private boolean lastLoadFailed = true;
    @Nullable
    private Instant[] resourceLastModifiedTimes;

    public ReloadableSpringService(@Nonnull @ParameterName(name="claz") Class<T> claz) {
        this(claz, new ClassBasedServiceStrategy<T>(claz));
    }

    public ReloadableSpringService(@Nonnull @ParameterName(name="claz") Class<T> claz, @Nonnull @ParameterName(name="strategy") NonnullFunction<ApplicationContext, AbstractServiceableComponent<T>> strategy) {
        this.theClaz = (Class)Constraint.isNotNull(claz, (String)"Class cannot be null");
        this.serviceStrategy = (NonnullFunction)Constraint.isNotNull(strategy, (String)"Strategy cannot be null");
        this.factoryPostProcessors = CollectionSupport.emptyList();
        this.postProcessors = CollectionSupport.emptyList();
        this.beanProfiles = CollectionSupport.emptyList();
        this.serviceConfigurations = CollectionSupport.emptyList();
    }

    @Nullable
    public ApplicationContext getParentContext() {
        return this.parentContext;
    }

    public void setParentContext(@Nullable ApplicationContext context) {
        this.checkSetterPreconditions();
        this.parentContext = context;
    }

    @Nonnull
    public List<Resource> getServiceConfigurations() {
        return this.serviceConfigurations;
    }

    public void setServiceConfigurations(@Nonnull List<Resource> configs) {
        this.checkSetterPreconditions();
        this.serviceConfigurations = CollectionSupport.copyToList((Collection)((Collection)Constraint.isNotNull(configs, (String)"Service configurations cannot be null")));
        if (!this.serviceConfigurations.isEmpty()) {
            Instant[] lastModifiedTimes = new Instant[this.serviceConfigurations.size()];
            int numOfResources = this.serviceConfigurations.size();
            for (int i = 0; i < numOfResources; ++i) {
                Resource serviceConfig = this.serviceConfigurations.get(i);
                try {
                    if (serviceConfig.exists()) {
                        lastModifiedTimes[i] = Instant.ofEpochMilli(serviceConfig.lastModified());
                        continue;
                    }
                    lastModifiedTimes[i] = null;
                    continue;
                }
                catch (IOException e) {
                    this.log.info("{} Configuration resource '" + serviceConfig.getDescription() + "' last modification date could not be determined", (Object)this.getLogPrefix(), (Object)e);
                    lastModifiedTimes[i] = null;
                }
            }
            this.resourceLastModifiedTimes = lastModifiedTimes;
        } else {
            this.resourceLastModifiedTimes = null;
        }
    }

    public void setServiceConfigurationStrategy(@Nonnull Function<?, List<Resource>> strategy) {
        this.checkSetterPreconditions();
        throw new UnsupportedOperationException("This UnsupportedOperationException method has not been implemented");
    }

    public void setBeanFactoryPostProcessors(@Nonnull List<BeanFactoryPostProcessor> processors) {
        this.checkSetterPreconditions();
        Constraint.isNotNull(processors, (String)"BeanFactoryPostProcessor collection cannot be null");
        this.factoryPostProcessors = CollectionSupport.copyToList(processors);
    }

    public void setBeanPostProcessors(@Nonnull List<BeanPostProcessor> processors) {
        this.checkSetterPreconditions();
        Constraint.isNotNull(processors, (String)"BeanPostProcessor collection cannot be null");
        this.postProcessors = CollectionSupport.copyToList(processors);
    }

    public void setBeanProfiles(@Nonnull Collection<String> profiles) {
        this.checkSetterPreconditions();
        this.beanProfiles = StringSupport.normalizeStringCollection(profiles);
    }

    public void setConversionService(@Nullable ConversionService service) {
        this.checkSetterPreconditions();
        this.conversionService = service;
    }

    public final void start() {
        try {
            this.initialize();
        }
        catch (ComponentInitializationException e) {
            throw new BeanInitializationException("Could not start service", (Throwable)e);
        }
    }

    public final void stop() {
        this.destroy();
    }

    public boolean isRunning() {
        return this.isInitialized() && !this.isDestroyed();
    }

    @Override
    protected boolean shouldReload() {
        Instant[] lastModifiedTimes = this.resourceLastModifiedTimes;
        if (lastModifiedTimes == null) {
            return false;
        }
        if (this.lastLoadFailed) {
            return true;
        }
        boolean configResourceChanged = false;
        int numOfResources = this.serviceConfigurations.size();
        for (int i = 0; i < numOfResources; ++i) {
            Resource serviceConfig = this.serviceConfigurations.get(i);
            try {
                if (lastModifiedTimes[i] == null && !serviceConfig.exists()) {
                    this.log.debug("{} Resource remains unavailable/inaccessible: '{}'", (Object)this.getLogPrefix(), (Object)serviceConfig.getDescription());
                    continue;
                }
                if (lastModifiedTimes[i] == null && serviceConfig.exists()) {
                    this.log.debug("{} Resource was unavailable, now present: '{}'", (Object)this.getLogPrefix(), (Object)serviceConfig.getDescription());
                    configResourceChanged = true;
                    lastModifiedTimes[i] = Instant.ofEpochMilli(serviceConfig.lastModified());
                    continue;
                }
                if (lastModifiedTimes[i] != null && !serviceConfig.exists()) {
                    this.log.debug("{} Resource was available, now is not: '{}'", (Object)this.getLogPrefix(), (Object)serviceConfig.getDescription());
                    configResourceChanged = true;
                    lastModifiedTimes[i] = null;
                    continue;
                }
                Instant serviceConfigLastModified = Instant.ofEpochMilli(serviceConfig.lastModified());
                if (!serviceConfigLastModified.equals(lastModifiedTimes[i])) {
                    this.log.debug("{} Resource has changed: '{}'", (Object)this.getLogPrefix(), (Object)serviceConfig.getDescription());
                    configResourceChanged = true;
                    lastModifiedTimes[i] = serviceConfigLastModified;
                    continue;
                }
                this.log.trace("{} Resource has not changed '{}'", (Object)this.getLogPrefix(), (Object)serviceConfig.getDescription());
                continue;
            }
            catch (IOException e) {
                this.log.info("{} Configuration resource '{}' last modification date could not be determined", new Object[]{this.getLogPrefix(), serviceConfig.getDescription(), e});
                configResourceChanged = true;
            }
        }
        this.resourceLastModifiedTimes = lastModifiedTimes;
        return configResourceChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doReload() {
        AbstractServiceableComponent<T> oldComponent;
        AbstractServiceableComponent component;
        GenericApplicationContext appContext;
        super.doReload();
        this.log.debug("{} Creating new ApplicationContext for service '{}'", (Object)this.getLogPrefix(), (Object)this.getId());
        this.log.debug("{} Reloading from {}", (Object)this.getLogPrefix(), this.getServiceConfigurations());
        try {
            appContext = new ApplicationContextBuilder().setName(this.getId()).setParentContext(this.getParentContext()).setServiceConfigurations(this.getServiceConfigurations()).setBeanFactoryPostProcessors(this.factoryPostProcessors).setBeanPostProcessors(this.postProcessors).setBeanProfiles(this.beanProfiles).setConversionService(this.conversionService).build();
        }
        catch (FatalBeanException e) {
            throw new ServiceException((Exception)((Object)e));
        }
        this.log.debug("{} New Application Context created for service '{}'", (Object)this.getLogPrefix(), (Object)this.getId());
        try {
            component = (AbstractServiceableComponent)this.serviceStrategy.apply((Object)appContext);
        }
        catch (Exception e) {
            appContext.close();
            throw new ServiceException("Failed to load " + String.valueOf(this.getServiceConfigurations()), e);
        }
        component.pinComponent();
        Object theObject = component.getComponent();
        this.log.debug("{} Testing that {} is a superclass of {}", new Object[]{this.getLogPrefix(), theObject.getClass(), this.theClaz});
        if (!this.theClaz.isAssignableFrom(theObject.getClass())) {
            component.unpinComponent();
            component.unloadComponent();
            throw new ServiceException("Class was not the same or a superclass of configured class");
        }
        ReloadableSpringService reloadableSpringService = this;
        synchronized (reloadableSpringService) {
            oldComponent = this.cachedComponent;
            this.cachedComponent = component;
            component.unpinComponent();
        }
        this.log.info("{} Completed reload and swapped in latest configuration for service '{}'", (Object)this.getLogPrefix(), (Object)this.getId());
        if (null != oldComponent) {
            this.log.debug("{} Unloading previous configuration for service '{}'", (Object)this.getLogPrefix(), (Object)this.getId());
            oldComponent.unloadComponent();
        }
        this.lastLoadFailed = false;
        this.log.info("{} Reload complete", (Object)this.getLogPrefix());
    }

    @Override
    protected void doDestroy() {
        AbstractServiceableComponent<T> oldComponent = this.cachedComponent;
        this.cachedComponent = null;
        if (null != oldComponent) {
            oldComponent.unloadComponent();
        }
        super.doDestroy();
    }

    @Override
    @Nonnull
    public synchronized AbstractServiceableComponent<T> getServiceableComponent() throws ServiceException {
        if (null != this.cachedComponent) {
            this.cachedComponent.pinComponent();
            assert (this.cachedComponent != null);
            return this.cachedComponent;
        }
        throw new ServiceException("Service component " + this.getId() + " is unavailable");
    }

    public void setApplicationContext(@Nonnull ApplicationContext applicationContext) {
        this.setParentContext(applicationContext);
    }

    public void setBeanName(@Nonnull String name) {
        this.beanName = name;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        if (this.getId() == null && this.beanName != null) {
            this.setId(this.beanName);
        }
        super.doInitialize();
    }
}

