/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.shared.logic;

import java.util.function.Function;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Implementation of {@link Function} that carries the nonnull annotation
 * on the {@link #apply(Object)} method's return value.
 * 
 * @param <T> input type
 * @param <U> output type
 */
public interface NonnullFunction<T,U> extends Function<T,U> {

    /** {@inheritDoc} */
    @Nonnull U apply(@Nullable T input);

}