/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.util.storage;

import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import org.opensaml.util.storage.ExpiringObject;
import org.opensaml.util.storage.StorageService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpiringObjectStorageServiceSweeper
extends TimerTask {
    private StorageService<Object, ? extends ExpiringObject> store;

    public ExpiringObjectStorageServiceSweeper(Timer taskTimer, StorageService<Object, ? extends ExpiringObject> sweptStore, long sweepInterval) {
        this.store = sweptStore;
        taskTimer.schedule((TimerTask)this, sweepInterval);
    }

    @Override
    public void run() {
        Collection<Object> storeKeys = this.store.getKeys();
        if (storeKeys != null) {
            for (Object key : storeKeys) {
                ExpiringObject value = this.store.get(key);
                if (!value.isExpired()) continue;
                this.store.remove(key);
            }
        }
    }
}

