/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.ws.security.provider;

import javax.servlet.http.HttpServletRequest;
import org.opensaml.ws.security.SecurityPolicyContext;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.ws.security.SecurityPolicyRule;
import org.opensaml.ws.security.SecurityPolicyRuleFactory;
import org.opensaml.xml.XMLObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPRuleFactory
implements SecurityPolicyRuleFactory<HttpServletRequest> {
    private String contentType;
    private String requestMethod;
    private String characterEncoding;
    private String requestScheme;
    private boolean requireSecured;

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String encoding) {
        this.characterEncoding = encoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(String method) {
        this.requestMethod = method;
    }

    public String getRequestScheme() {
        return this.requestScheme;
    }

    public void setRequestScheme(String scheme) {
        this.requestScheme = scheme;
    }

    public boolean isRequireSecured() {
        return this.requireSecured;
    }

    public void setRequireSecured(boolean secured) {
        this.requireSecured = secured;
    }

    @Override
    public SecurityPolicyRule<HttpServletRequest> createRuleInstance() {
        return new HTTPRule(this.getContentType(), this.getCharacterEncoding(), this.getRequestScheme(), this.getRequestMethod(), this.isRequireSecured());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class HTTPRule
    implements SecurityPolicyRule<HttpServletRequest> {
        private String contentType;
        private String requestMethod;
        private String characterEncoding;
        private String requestScheme;
        private boolean requireSecured;

        public HTTPRule(String type, String encoding, String scheme, String method, boolean secured) {
            this.contentType = type;
            this.characterEncoding = encoding;
            this.requestScheme = scheme;
            this.requestMethod = method;
            this.requireSecured = secured;
        }

        @Override
        public void evaluate(HttpServletRequest request, XMLObject message, SecurityPolicyContext context) throws SecurityPolicyException {
            if (this.contentType != null && !request.getContentType().contains(this.contentType)) {
                throw new SecurityPolicyException("Invalid content type, expected " + this.contentType + " but was " + request.getContentType());
            }
            if (this.characterEncoding != null && !request.getCharacterEncoding().equals(this.characterEncoding)) {
                throw new SecurityPolicyException("Invalid character encoding, expected " + this.characterEncoding + " but was " + request.getCharacterEncoding());
            }
            if (this.requestScheme != null && !request.getScheme().equals(this.requestScheme)) {
                throw new SecurityPolicyException("Invalid request scheme, expected " + this.requestScheme + " but was " + request.getScheme());
            }
            if (this.requestMethod != null && !request.getMethod().equals(this.requestMethod)) {
                throw new SecurityPolicyException("Invalid request method, expected " + this.requestMethod + " but was " + request.getMethod());
            }
            if (this.requireSecured && !request.isSecure()) {
                throw new SecurityPolicyException("Request was required to be secured but was not");
            }
        }
    }
}

