/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.extensions.text.highlight.scanner;

import java.util.HashMap;
import org.aesh.extensions.highlight.Encoder;
import org.aesh.extensions.highlight.StringScanner;
import org.aesh.extensions.highlight.Syntax;
import org.aesh.extensions.highlight.scanner.JavaScriptScanner;
import org.aesh.extensions.text.highlight.encoder.NullEncoder;
import org.aesh.extensions.text.highlight.scanner.AbstractScannerTestCase;
import org.junit.Ignore;
import org.junit.Test;

public class JavaScriptScannerTestCase
extends AbstractScannerTestCase {
    @Test
    public void shouldMatchJavaScriptEtienneMassipExample() throws Exception {
        this.assertMatchExample(Syntax.Builder.create(), "javascript", "etienne-massip.in.js");
    }

    @Test
    public void shouldMatchJavaScriptGordonExample() throws Exception {
        this.assertMatchExample(Syntax.Builder.create(), "javascript", "gordon.in.js");
    }

    @Test
    public void shouldMatchJavaScriptPrototypeExample() throws Exception {
        this.assertMatchExample(Syntax.Builder.create(), "javascript", "prototype.in.js");
    }

    @Test
    public void shouldMatchJavaScriptReadabilityExample() throws Exception {
        this.assertMatchExample(Syntax.Builder.create(), "javascript", "readability.in.js");
    }

    @Test
    public void shouldMatchJavaScriptScriptAculoUSExample() throws Exception {
        this.assertMatchExample(Syntax.Builder.create(), "javascript", "script.aculo.us.in.js");
    }

    @Test
    public void shouldMatchJavaScriptSunSpiderExample() throws Exception {
        this.assertMatchExample(Syntax.Builder.create(), "javascript", "sun-spider.in.js");
    }

    @Test
    public void shouldMatchJavaScriptTraceTestExample() throws Exception {
        this.assertMatchExample(Syntax.Builder.create(), "javascript", "trace-test.in.js");
    }

    @Test
    @Ignore
    public void shouldMatchJavaScriptXMLExample() throws Exception {
        this.assertMatchExample(Syntax.Builder.create(), "javascript", " xml.in.js");
    }

    @Test
    @Ignore
    public void performance() throws Exception {
        String content = this.fetch("javascript", "sun-spider.in.js");
        HashMap options = new HashMap();
        NullEncoder encoder = new NullEncoder();
        JavaScriptScanner scanner = new JavaScriptScanner();
        for (int i = 0; i < 60; ++i) {
            long start = System.currentTimeMillis();
            scanner.scan(new StringScanner(content), (Encoder)encoder, options);
            System.out.println(i + " [" + (System.currentTimeMillis() - start) + "]");
        }
    }
}

